#
#  Sendmail
#  Copyright (c) 1983  Eric P. Allman
#  Berkeley, California
#
#  Copyright (c) 1983 Regents of the University of California.
#  All rights reserved.  The Berkeley software License Agreement
#  specifies the terms and conditions for redistribution.
#
#	@(#)arpa.mc	1.1 (Berkeley) 8/13/85
#
############################################################
############################################################
#####
#####		SENDMAIL CONFIGURATION FILE
#####
#####
############################################################
############################################################



##################
#   local info   #
##################

# internet hostname
Cwucbarpa arpa arpavax ucbarpavax r UCB-ARPA

# uucp hostnames
DUucbarpa
CUucbarpa

# local UUCP connections
CWmetron

# we have full sendmail support here
Oa

#############################
###   Setup Information   ###
#############################

include(nsmacros.m4)
include(nsclasses.m4)
include(cchosts.m4)
include(berkhosts.m4)
include(version.m4)
include(boilerplate.m4)

###########################
###   Rewriting Rules   ###
###########################

include(prewriterule.m4)
include(postwriterule.m4)
include(rule3.m4)

###################
###   Mailers   ###
###################

include(localm.m4)
include(nstcpm.m4)
include(mmdfm.m4)
include(euucpm.m4)

#####################
###   Rule Zero   ###
#####################

S0

# first make canonical
R$*<$*>$*		$1$2$3				defocus
R$+			$:$>3$1				make canonical

# handle special cases.....
R@			$#local$:$n			handle <> form
R$*<@[$+]>$*		$#tcp$@[$2]$:$1@[$2]$3		numeric internet spec

# hack for Australian addresses (avoid conflict with local host "oz")
R$*<@$+.OZ>$*		$1<@$2.OZ.AU>$3

# arrange for local names to be fully qualified
R$*<$+.ARPA.LOCAL>$*	$1<$2.ARPA>$3			because ARPA is a host

# now delete the local info
R$*<$*$=w.$=T>$*	$1<$2>$5			thishost.LOCAL
# remove next line as it screws up arpa connections
# R$*<$*$=w>$*		$1<$2>$4			thishost
R$*<$*.>$*		$1<$2>$3			drop trailing dot
R<@>:$*			$@$>0$1				retry after route strip
R$*<@>			$@$>0$1				strip null trash & retry

# forward around hosts with communication problems
R$*<@$=F.LOCAL>$*	$#tcp$@$F$:$1<@$2.LOCAL>$3	reroute message

##################################
#  End of ruleset zero preamble  #
##################################
################################################
###  Machine dependent part of ruleset zero  ###
################################################

# resolve names we can handle locally
R<@$=W.UUCP>:$+		$#uucp$@$1$:$2			@host.UUCP:...
R$+<@$=W.UUCP>		$#uucp$@$2$:$1			user@host.UUCP

# pass test addresses off to MMDF
R$+@UDel-Test		$#mmdf$@UDel-Test$:$1		user.host@udel-relay

# resolve names destined for the computer center
R$*<@$+.CC>$*		$#tcp$@$C$:$1<@$2.CC>$3	user@host.CC

# resolve names destined for berknet sites
R<@$=Z>:$+		$#tcp$@$B$:$2@$1		@berkhost: ...
R$+<@$=Z>		$#tcp$@$B$:$1@$2		user@berknethost

# resolve explicit known foreign networks
R$*<@$+.Oz>$*		$#tcp$@seismo.css.gov$:$1<@$2.Oz>$3	down-under
R$*<@$+.Oz.au>$*	$#tcp$@seismo.css.gov$:$1<@$2.Oz>$3	down-under
R$*<@$+.BITNET>$*	$#tcp$@$C$:$1<@$2.BITNET>$3	user@host.BITNET
R$*<@$+.CSNET>$*	$#tcp$@CSNET-RELAY.ARPA$:$1<@$2.CSNET>$3	user@host.CSNET
R$*<@$+.DEC>$*		$#tcp$@decwrl.ARPA$:$1<@$2.DEC>$3	user@host.DEC
R$*<@$+.MailNET>$*	$#tcp$@MIT-Multics.ARPA$:$1<@$2.MailNET>$3	user@host.MailNET
R$*<@$*.UUCP>$*		$#tcp$@$F$:$1<@$2.UUCP>		uucp mail

# other non-local names 
R$*<@$+>$*		$#tcp$@$2$:$1<@$2>$3		user@some.where

# remaining names must be local
R$+			$#local$:$1			everything else

########################################
###  Host dependent address cleanup  ###
########################################

S8
R$*$=U!$+@$+		$3@$4				drop uucp forward

