#include <stdio.h>

#define BUFSIZE 1024
#define BMAGIC  0x10200		/* magic number for bitmap files */
struct bitmap {
	long b_magic;
	int  b_width;
	int  b_height;
	int  b_hres;
	int  b_vres;
	char unused[20];
} headinfo;
short   RES;
short	i,j,n,width,length;
long	nloops,nread[20];
char	*cp;
char	outbuf[BUFSIZE];
char	init1[]={'\033','E'};				/* master reset   */
char	portrait[]={'\033','&','l','0','O'};		/* portrait mode  */
char	res75[]={'\033','*','t','7','5','R'};		/* resolution     */
char	res100[]={'\033','*','t','1','0','0','R'};	/* resolution     */
char	res150[]={'\033','*','t','1','5','0','R'};	/* resolution     */
char	res300[]={'\033','*','t','3','0','0','R'};	/* resolution     */
char	startmode[]={'\033','*','r','0','A'};		/* start raster   */
char	bytemode1[]={'\033','*','b'};			/* start transfer */ 
char	bytemode2[]={'W'}; 
char	bytemode3[4];
char	endmode[]={'\033','*','r','B'};			/* end raster     */
char    endchars[]={'\015','\014'};			/* form feed      */

main(argc,argv)
int argc;
char *argv[];
{
   short i,j;
   char *p;
   int   res;
   
      RES = 150;
      p = argv[1];
      p += 2;
      res = atoi(p);

      if (res ==  75) RES =  75;
      if (res == 100) RES = 100;
      if (res == 150) RES = 150;
      if (res == 300) RES = 300;

      while (read(0,&headinfo,sizeof(struct bitmap)) == sizeof(struct bitmap))
      {
	 if (headinfo.b_magic != BMAGIC) {
	    fprintf(stderr,
	      " HP Bitmap Filter: unknown input: should be (%d) is (%d)\n",
	      BMAGIC,headinfo.b_magic);
	    exit(1);
	 }
	 else {
            width  = (((headinfo.b_width+15)>>4)<<1);
	    sprintf(bytemode3,"%d",width);
            calculate_loops();

            for (i=0;i<nloops;i++) {
               send_header();
               send_data(nread[i]);
               send_trailer();
            }
         }
      }
}

calculate_loops()
{
   short ih,height;
   ih = (55000) / (sizeof(bytemode1) + sizeof(bytemode2) + 
                 strlen(bytemode3) + width );
   nloops = 0;
   height = headinfo.b_height;
   while (height > 0) {
      if (ih < height) nread[nloops] = ih;
      else             nread[nloops] = height;
      height -= ih;
      nloops ++;
   }
}

send_header()
{
   if (write(1,init1,sizeof(init1)) != sizeof(init1)) leave(1);
   if (write(1,portrait,sizeof(portrait)) != sizeof(portrait)) leave(2);
   if (RES == 75)
      if (write(1,res75,sizeof(res75)) != sizeof(res75)) leave(3);
   if (RES == 100)
      if (write(1,res100,sizeof(res100)) != sizeof(res100)) leave(4);
   if (RES == 150) 
      if (write(1,res150,sizeof(res150)) != sizeof(res150)) leave(5);
   if (RES == 300) 
      if (write(1,res300,sizeof(res300)) != sizeof(res300)) leave(5);
   if (write(1,startmode,sizeof(startmode)) != sizeof(startmode))leave(6);
}

send_trailer()
{
   if (write(1,endmode,sizeof(endmode)) != sizeof(endmode)) leave(7); 
   if (write(1,endchars,sizeof(endchars)) != sizeof(endchars)) leave(8);
   sleep(30);
}

send_data(nrasters)
short nrasters;
{
   for (i=0;i<nrasters;i++) {
        if (write(1,bytemode1,sizeof(bytemode1)) != sizeof(bytemode1))
	   leave(9);
        if (write(1,bytemode3,strlen(bytemode3)) != strlen(bytemode3))
	   leave(10);
        if (write(1,bytemode2,sizeof(bytemode2)) != sizeof(bytemode2))
	   leave(11);
        n = read(0,outbuf,width);
        for (cp = &(outbuf[0]),j=0;j<n;j++,cp++) *cp = ~(*cp);
	if (write(1,outbuf,n) != n) leave(12);
   }   
}

leave(line)
short line;
{
   fprintf(stderr," HP Bitmap Filter: error on write(%d)\n",line);
   exit(1);
}
