/* pbm:   version 1:  - ability to read bitmaps
		      - each bit is tripled
		      - plot comes out sideways
	  version 2:  - plot is flipped to come out correctly.
	  version 3:  - CRT Graphics 2 instead of triple_bits.
	  version 4:  - using double density (120 bpi horizontal)
			doing 2/3 in vertical direction.
*/

#include <stdio.h>
#include <bitmap.h>

#define OBUFLEN 1024               /* length of the output buffer        */
#define K96     768*128            /* length in bytes of 96K bits        */

unsigned char outbuf[OBUFLEN];	   /* output buffer                      */
unsigned char holdbuf[3*OBUFLEN];  /* temporary hold buffer              */
int outptr = 0;			   /* output buffer pointer              */
unsigned char buf[K96];     /* buffer to hold the complete bitmap */
struct bitmap headinfo;            /* bitmap header structure BITMAP(5)  */


main()
{
    register int i,j,m;            /* generic counters                   */
    unsigned char bytes[10];	   /* array for the expanded bits        */
    register int nprow;		   /* points to start of current region  */ 
    unsigned char flipbyte[10];    /* for vertically packing bits        */
    register int width;            /* actual width in bytes              */
    register int height;           /* bitmap height in bytes             */
    register short done;           /* flag for reading bitmap            */
    register int sumbytes;         /* total number of bytes in bitmap    */
    register unsigned char *ip = buf;   /* pointer into buffer           */
    register int npoints;          /* horizontal points per line         */
    unsigned char flip();          /* function to vertically pack bits   */
    
    /*****************/
    /*  Read Bitmap  */
    /*****************/
    (void) read(0,&headinfo,40);      /* read bitmap header */

    width  = ((headinfo.b_width+15)>>4)<<1;
    height = headinfo.b_height;
    sumbytes = (width-1)*(height-1);
    npoints = headinfo.b_width;

    for (i=sumbytes;i<K96;i++) buf[i] = 0xff;

    done   = 0;
    while (!done) {
       m = read(0,ip,1024);
       if (m>0) ip+=m;
       else done=1;
    }

    /***********************************/
    /* initialize epson LQ1500 printer */
    /***********************************/

    putone (033);    /* ESCAPE                   */
    putone ('@');    /* master reset             */
    putone (033);    /* ESCAPE                   */
    putone ('3');    /* set correct line spacing */
    putone (030);    /* ----> 24/180 inch space  */
    putone (033);    /* ESCAPE                   */
    putone ('U');    /* set directional printing */
    putone (1);      /* ----> unidirectional     */
    putone (033);    /* ESCAPE                   */
    putone ('O');    /* cancel skip over perf    */


    for (nprow = 0; nprow < height; nprow+=16) {

	/**********************************/
	/* loop through bytes for one row */
	/* saving bottom half of write    */
	/**********************************/
	putone (0x1b);		/* send codes to printer for bit image */
	putone ('*');		/* bit image mode */
	putone (33);		
	putone (npoints & 0xff); /* points of data to follow */
	putone ((npoints >> 8) & 0xff);
	for (j=0;j<headinfo.b_width;j++) {

	   flipbyte[0] = flip(j,(nprow*width),width);
	   flipbyte[1] = flip(j,((nprow+8)*width),width);

	   expand(flipbyte,bytes);

	   putone (~bytes[0]);
	   putone (~bytes[1]);
	   putone (~bytes[2]);
	}
	putone ('\n');
	putone ('\r');
    }
    putone ('\f');
    flushbuf();
}


expand (in, out)
unsigned char in[10], out[10];
{
	register int i;

	/*************************/
	/*************************/

	i = (in[0] >> 7) & 1;
	    out[0]  = (i << 7) | (i << 6);   /*  [0].7 ---> [0].7,6 */
	i = (in[0] >> 6) & 1;
	    out[0] |=            (i << 5);   /*  [0].6 ---> [0].5   */
	i = (in[0] >> 5) & 1;
	    out[0] |= (i << 4) | (i << 3);   /*  [0].5 ---> [0].4,3 */
	i = (in[0] >> 4) & 1;
	    out[0] |=            (i << 2);   /*  [0].4 ---> [0].2   */
	i = (in[0] >> 3) & 1;
	    out[0] |= (i << 1) | (i) ;       /*  [0].3 ---> [0].1,0 */


	i = (in[0] >> 2) & 1;
	    out[1]  = (i << 7);              /*  [0].2 ---> [1].7   */
	i = (in[0] >> 1) & 1;
	    out[1] |= (i << 6) | (i << 5);   /*  [0].1 ---> [1].6,5 */
	i = in[0] & 1;
	    out[1] |= (i << 4);              /*  [0].0 ---> [1].4   */

	i = (in[1] >> 7) & 1;
	    out[1] |= (i << 3) | (i << 2);   /*  [1].7 ---> [1].3,2 */
	i = (in[1] >> 6) & 1;
	    out[1] |= (i << 1);              /*  [1].6 ---> [1].1   */


	i = (in[1] >> 5) & 1;
	    out[1] |= (i);                   /*  [1].5 ---> [1].0   */
	    out[2]  = (i << 7);              /*  [1].5 ---> [2].7   */

	i = (in[1] >> 4) & 1;
	    out[2] |= (i << 6);              /*  [1].4 ---> [2].6   */
	i = (in[1] >> 3) & 1;
	    out[2] |= (i << 5) | (i << 4);   /*  [1].3 ---> [2].5,4 */
	i = (in[1] >> 2) & 1;
	    out[2] |= (i << 3);              /*  [1].2 ---> [2].3   */
	i = (in[1] >> 1) & 1;
	    out[2] |= (i << 2) | (i << 1);   /*  [1].1 ---> [2].2,1 */
	i = in[1] & 1;
	    out[2] |= (i);                   /*  [1].0 ---> [2].0   */
}


/*
 *	putone - add one character to the output buffer.  If the buffer is full,
 *	write the contents and check for errors.
 */

putone (c)
int c;
{
    outbuf[outptr] = c;
    outptr++;
    if (outptr >= OBUFLEN)
	flushbuf();
}


/*
 *	flushbuf - write the buffer to the output device.  Check for errors.
 */

flushbuf()
{
    int iret;
    unsigned char iobuf[16];

    if (outptr > OBUFLEN) {
	fprintf (stderr, "Trying to write too many bytes: %d\n", outptr);
	outptr = OBUFLEN;
    }
    iret = write (1, outbuf, outptr);
    if (iret == outptr) {
	outptr = 0;
	return;
    }
    fprintf (stderr, "dumpsc: write error\n");
    outptr = 0;
}

unsigned char flip(j,screenp,width)
int j,screenp,width;
{
   int  i,shiftr,wrap;
   unsigned char flipbyte;

   wrap = screenp + j/8;
   shiftr  = 7 - j%8;
   flipbyte &= 0;
   for (i=0;i<8;i++) {
      flipbyte |= ( ((buf[wrap] >> shiftr) & 1) << (7-i) );
      wrap += width;
   }
   return(flipbyte);
}
