#include <stdio.h>
#define true 1
#define false 0
struct filetype {
	unsigned int elementsize: 24;
	unsigned int open: 1 ;
	unsigned int read: 1;
	unsigned int linemark: 1;
	unsigned int valid : 1 ;/* is the thing in buffervar valid or not */
	unsigned int text : 1;
	unsigned int eof : 1 ;
	unsigned int temp: 1;	/* is this a temporary file? */
	char *filename;
	FILE *filevar;
/* if more fields are added above this, then the magic number 96 in iscsize()
    in pasdec.p may need to be changed (96=sizeof(filetype)-sizeof(buffervar)*/
	char buffervar;
};
/* make sure there is an eol before eof (?null file excepted?) */

struct filetype _input =  {1,1,1,1,0,1,0,0,"",stdin};
struct filetype _output = {1,1,0,1,0,1,1,0,"",stdout};
	/* it is illegal to apply reset/rewrite to input/output so I make no
	   provisions to deal with it (it won't work, since "" is not stdout's
	   name
	*/

static char *copy(str) char *str ; {
    char *malloc();
    register char *pt ;

    pt = malloc(strlen(str)+1);
    strcpy( pt,str );
return( pt );
}

static char *mktemp(str) char *str ; {
    /* this is here because the standard mktemp only gives 26 names */
    static int which;
    register char *pt ;
    register unsigned int i;

    pt = str;
    str += strlen( str )-6 ;
    i=which/72;
    if ( i<=9 )
    	*(str++)= '0'+i;
    else if ( i<=35 )
    	*(str++)= 'a'-10+i;
    else
    	*(str++)= 'A'-36+i;
    i = which%72;
    if ( i<=9 )
    	*(str++)= '0'+i;
    else if ( i<=35 )
    	*(str++)= 'a'-10+i;
    else
    	*(str++)= 'A'-36+i;
    which++;
    i=getpid();
    while ( i!= 0 ) {
	if ((i&0xf)<=9 )
	    *(str++)= '0'+(i&0xf);
	else
	    *(str++)= 'a'-10+(i&0xf);
	i >>= 4;
    }
    while ( *str=='X' || *str == 'x' ) *(str++)= '0';
return( pt );
}

_rewrite(f, filename, elementsize)
struct filetype *f;
char *filename;
{
    char *mktemp();
    FILE *fopen();
    int temp = filename==0;

    if (filename == 0)
	filename = mktemp(copy("/tmp/pasrtXXXXXX"));
    else
    	filename = copy( filename );
    if (f->open) {
    	if (!f->linemark && f->text)
	    _writeln(f);
	fclose(f->filevar);
	if ( ! temp && f->temp )
	    unlink( f->filename );
    }
    f->filename = filename;
    f->temp = temp;
    if ((f->filevar = fopen(filename, "w")) == NULL) {
	perror(filename);
	exit(1);
    } else {
	f->open = true;
	f->read = false;
	f->elementsize = elementsize;
	f->linemark = true;
	f->valid = false;
	f->text = false;
	f->eof = true ;
    }
}

_put(f)
struct filetype *f;
{
    if (!f->open)
	_runtimeerror("File not open\n");
    else if (f->read)
	_runtimeerror("File not open for writing\n");
    else if (!f->valid)
    	_runtimeerror("Buffer variable undefined\n");
    else
	fwrite(&f->buffervar, f->elementsize, 1, f->filevar);
    f->valid = false ;
    f->linemark = false;
}

_writeln(f)
struct filetype *f;
{
    if(!f->open) _runtimeerror("File not open\n");
    putc('\n', f->filevar);
    f->linemark = true;
    f->text=true ;
}

_page(f)
struct filetype *f;
{
    if(!f->open) _runtimeerror("File not open\n");
    if (!f->linemark)
	_writeln(f);
    putc('\014', f->filevar);
}

_writechr(f, c, totalwidth)
struct filetype *f;
char c;
{
    if(!f->open) _runtimeerror("File not open\n");
    if ( totalwidth<= 0 ) _runtimeerror("Width or fracdig is not positive\n" );
    fprintf(f->filevar, "%*c", totalwidth, c);
    f->text=true ;
}

_writeint(f, i, totalwidth)
struct filetype *f;
{
    if(!f->open) _runtimeerror("File not open\n");
    if ( totalwidth<= 0 ) _runtimeerror("Width or fracdig is not positive\n" );
    fprintf(f->filevar, "%*d", totalwidth, i);
    f->text=true ;
}

_writeexp(f, r, totalwidth)
struct filetype *f;
double r;
{
    if(!f->open) _runtimeerror("File not open\n");
    if ( totalwidth<= 0 ) _runtimeerror("Width or fracdig is not positive\n" );
    fprintf(f->filevar, " %*e", totalwidth, r);
    f->text=true ;
}

_writefix(f, r, totalwidth, fracdig)
struct filetype *f;
double r;
{
    if(!f->open) _runtimeerror("File not open\n");
    if ( totalwidth<= 0 || fracdig <= 0 ) 
    	_runtimeerror("Width or fracdig is not positive\n" );
    fprintf(f->filevar, "%*.*f", totalwidth, fracdig, r);
    f->text=true ;
}

_writeboo(f, b, totalwidth)
struct filetype *f;
char b;
{
    if (b == 1)
	_writestr(f, "true", totalwidth, 4);
    else
	_writestr(f, "false", totalwidth, 5);
}

_writestr(f, s, totalwidth, strlen)
struct filetype *f;
char *s;
{
    if(!f->open) _runtimeerror("File not open\n");
    if ( totalwidth<= 0 ) _runtimeerror("Width or fracdig is not positive\n" );
    if ( totalwidth < strlen )
    	strlen = totalwidth;
    fprintf(f->filevar, "%*.*s", totalwidth, strlen, s);
    f->text=true ;
}

_reset(f, filename, elementsize)
struct filetype *f;
char *filename;
{
    FILE *fopen();

    if (!f->linemark && f->open && f->text)
	_writeln(f);
    if (!f->open)
    	f->text=false ;
    if (filename != 0) {
	if (f->open) {
	    fclose(f->filevar);
	    if ( f->temp )
	    	unlink( f->filename );
	}
	if ((f->filevar = fopen(filename, "r")) == 0)
	    perror(filename);
	else {
	    f->open = true;
	    f->read = true;
	    f->elementsize = elementsize;
	    f->temp = false;
	    f->filename= copy(filename);
	}
    } else
	if (f->open) {
	    fclose( f->filevar );
	    f->filevar = fopen( f->filename,"r" );
	    f->read = true;
	} else
	    _runtimeerror("Cannot reset undefined file variable\n");
    f->linemark = false;	/* pascal says so */
    f->valid = false ;
    f->text = false ;
    f->eof = false ;
}

_setupfil(f) /* evar(f) */
struct filetype *f;
{
    if ( f->read && ! f->valid ) {
	_read(f, &f->buffervar);
	if (!f->eof)
	    f->valid = true ;
	f->linemark = false;
    } else if ( ! f->read )
    	f->valid = true ;
}

_eof(f)
struct filetype *f;
{
    if (!f->open) _runtimeerror("File not open\n" );
    _setupfil(f);
    return (f->eof);
}

_get(f)
struct filetype *f;
{
    /* this code is repeated in gettext */
    if ( !f->read )
    	_runtimeerror("File not open for reading\n");
    else if ( f->valid )
        f->valid = false ;
    else if ( f->eof )
    	_runtimeerror("Attempt to read past end of file\n");
    else
	_read(f,&f->buffervar);
}

_read(f, v)
struct filetype *f;
char *v;
{
    register int cnt ;

    if (!f->open)
	_runtimeerror("File not open\n");
    else if (!f->read)
	_runtimeerror("File not open for reading\n");
    else if (f->eof)
	_runtimeerror("Attempt to read past end of file\n");
    else if (feof(f->filevar))
    	f->eof=true;
    else if ((cnt=fread(v, f->elementsize, 1, f->filevar)) == -1)
	_runtimeerror("File is not an even number of records long\n");
    else if (cnt==0 && f->text && ! f->linemark)
	*v = '\n';
    else if (cnt==0)
    	f->eof = true ;
    f->valid = false ;	/* since the buffervar doesn't contain it, v does */
}

_eoln(f)
struct filetype *f;
{
    if (!f->open)
	_runtimeerror("File not open\n");
    _setuptex(f);
    if ( f->eof ) _runtimeerror("Attempt to read beyond end of file\n" );
    return(f->linemark);
}

_setuptex(f) /* tfilevar(f) */
struct filetype *f;
{
    if (f->valid) {
	if (f->buffervar == '\n' ) {
	    f->buffervar = ' ';
	    f->linemark = true;
	}
return;
    }
    f->text=true ;
    _setupfil(f);
    if (f->buffervar == '\n') {
	f->buffervar = ' ';
	f->linemark = true ;
    } else
        f->linemark = false ;
}

_gettext(f)
struct filetype *f;
{
    /* this code is a copy of get */
    if ( !f->read )
    	_runtimeerror("File not open for reading\n");
    else if ( f->valid )
        f->valid = false ;
    else if ( f->eof )
    	_runtimeerror("Attempt to read past end of file\n");
    else
	_read(f,&f->buffervar);
}

_readln(f)
struct filetype *f;
{
    while ( ! _eoln(f))
	_gettext(f);
    _gettext(f);
}

_readchr(f)
struct filetype *f;
{
    char ret;

    if (f->valid) {
	ungetc(f->buffervar,f->filevar);
	f->valid=false ;
    }
    if ( fscanf(f->filevar, "%c", &ret)!= 1 )
	_runtimeerror("Invalid character\n" );
    return ret;
}

_readint(f)
struct filetype *f;
{
    int ret;

    if (f->valid) {
	ungetc(f->buffervar,f->filevar);
	f->valid=false ;
    }
    if ( fscanf(f->filevar, "%d", &ret)!= 1 )
    	_runtimeerror( "Invalid integer\n" );
    return ret;
}

double _readreal(f)
struct filetype *f;
{
    double ret;

    if (f->valid) {
	ungetc(f->buffervar,f->filevar);
	f->valid=false ;
    }
    if ( fscanf(f->filevar, "%lf", &ret)!= 1 )
    	_runtimeerror( "Invalid real\n" );
    return ret;
}

_runtimeerror(msg)
char *msg;
{
	fprintf(stderr, msg);
	_exit(1);
}

_rnerr(num,linenum) int num,linenum ; {
    /* pascall runtime error msgs (in line) */
    switch(num) {
    case 1:
    	fprintf( stderr, "Array index/variable assignment out of bounds on line %d\n", linenum ); break ;
    }
    exit(num+1);
}

#ifdef STANDALONE
NEW(pt,size) char **pt ; int size ; {
    char *calloc();

    *pt = calloc(1,size);
    if (*pt == NULL)
	_runtimeerror( "Memory limit exceeded\n" );
}

DISPOSE(pt,size) char *pt ; int size ; {

    if ( pt == 0 )
	_runtimeerror( "Attempted to dispose NIL object\n" );
    else
	cfree( pt );
}
/*
DISPOSE(pt,size) char **pt ; int size ; {

    if ( *pt == 0 ) _runtimeerror( "Attempted to dispose NIL object\n" );
    cfree( *pt );
    *pt = 0 ;
}
*/
#endif STANDALONE
double _log(x) double x ; {
    double log();

    if ( x<=0.0 ) _runtimeerror("Negative or zero argument to ln\n");
return( log(x));
}

double _sqrt(x) double x ; {
    double sqrt();

    if ( x<0.0 ) _runtimeerror("Negative argument to sqrt\n");
return( sqrt(x));
}

_errno() {
    extern int errno ;

return(errno);
}

__exit() {
    exit(0);
}

#include <signal.h>
#include <setjmp.h>

int errnum;
int *_disply[32];
int _argc;
char **_argv;

ARGV(argnumx,r11,count)
register count;
register char *r11;
{
    register char *r10;

    r10 = _argv[argnumx];
    do {
        *r11++ = *r10++;
    } while (--count != 0 && *r10 != 0);
    while (count-- != 0)
        *r11++ = ' ';
}
