/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)putc_.c	5.1	6/7/85
 */

/*
 * write a character to the standard output
 *
 * calling sequence:
 *	integer putc
 *	ierror =  putc (char)
 * where:
 *	char will be sent to the standard output, usually the terminal
 *	ierror will be 0 if successful; a system error code otherwise.
 */

#ifdef is68k
#include	"../../libI77/src/f_errno.h"
#include	"../../libI77/src/fiodefs.h"
#else
#include	"../libI77/f_errno.h"
#include	"../libI77/fiodefs.h"
#endif is68k

extern unit units[];	/* logical units table from iolib */

long putc_(c, clen)
char *c; long clen;
{
	int	i;
	unit	*lu;

	lu = &units[STDOUT];
	if (!lu->ufd)
		return((long)(errno=F_ERNOPEN));
	if (!lu->uwrt && ! nowwriting(lu))
		return((long)errno);
	putc (*c, lu->ufd);
	if (ferror(lu->ufd))
	{
		i = errno;
		clearerr(lu->ufd);
		return((long)i);
	}
	return(0L);
}
