/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)endfile.c	5.2	7/30/85
 */

/*
 * endfile
 */

#include "fio.h"

static char	endf[]	= "endfile";

f_end (a)
alist	*a;
{
	unit	*b;
	int n;

	lfname = NULL;
	elist = NO;
	errflag = a->aerr;
#ifdef	SILICON_SOLUTIONS
	lunit = tr_unit(a->aunit,endf);
#else
	lunit = a->aunit;
	if (not_legal(lunit))
		err (errflag, F_ERUNIT, endf)
#endif
	b = &units[lunit];
#ifdef SILICON_SOLUTIONS
	if(!b->ufd && (n = fk_open(READ, SEQ, FMT, (ftnint)a->aunit)))
#else
	if(!b->ufd && (n = fk_open(READ, SEQ, FMT, (ftnint)lunit)) )
#endif SILICON_SOLUTIONS
		err(errflag, n, endf);
	if (b->uend)
		return(0);
	lfname = b->ufnm;
	b->uend = YES;
	return ( t_runc (b, errflag, endf) );
}
