#! /bin/csh -f
#
# name:
#	validate
#
# synopsis:
#	validate <format> <value>
#
# description:
#	checks the second argument to see if it is a valid for given
#	the first argument as a descriptor.  Known descriptors are:
#		HOSTNAME
#		NET_INET
#		NET_CTLR
#
#echo "VALIDATE $1 $2, count=$#argv"
switch ( $1 )
case HOSTNAME :
	if ( $#argv != 2 ) \
		exit(1)
	echo $2 | grep -s -w  '^[a-zA-Z][a-zA-Z0-9_\.-]*$'
	if ( $status != 0 ) \
		exit(2)
	exit(0)
	breaksw
case NET_INET :
	if ( $#argv != 2 ) \
		exit(1)
	echo $2 | grep -s -w '^[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*$'
	if ( $status != 0 ) \
		exit (2)
	set ADX=`echo $2 | awk '{FS="."} {print $1 " " $2 " " $3 " " $4}'`
	if ( 1 <= $ADX[1] && $ADX[1] <= 223 \
	  && 0 <= $ADX[2] && $ADX[2] <= 254 \
  	  && 0 <= $ADX[3] && $ADX[3] <= 254 \
	  && 0 <= $ADX[4] && $ADX[4] <= 254) then
		exit(0)
	else
		exit(3)
	endif
	breaksw
case NET_CTLR :
	if ( $#argv != 2 ) \
		exit(1)
	echo $2 | grep -s -w '^ex[0-3]$' ; if ( $status == 0 ) exit(0)
	echo $2 | grep -s -w '^il[0-3]$' ; if ( $status == 0 ) exit(0)
	echo $2 | grep -s -w '^nw[0-3]$' ; if ( $status == 0 ) exit(0)
	echo $2 | grep -s -w '^tty[0-9][0-9a-f]*$' ; if ( $status == 0 ) exit(0)
	echo $2 | grep -s -w '^tty[ih][0-9a-f]*$' ; if ( $status == 0 ) exit(0)
	echo $2 | grep -s -w '^vb0$' ; if ( $status == 0 ) exit(0)
	exit(1)
	breaksw
case ETHER_CTLR :
	if ( $#argv != 2 ) \
		exit(1)
	echo $2 | grep -s -w '^ex[0-3]$' ; if ( $status == 0 ) exit(0)
	echo $2 | grep -s -w '^il[0-3]$' ; if ( $status == 0 ) exit(0)
	echo $2 | grep -s -w '^nw[0-3]$' ; if ( $status == 0 ) exit(0)
	exit(1)
	breaksw
case NET_SLP :
	if ( $#argv != 3 ) \
		exit(1)
	if ( ! { validate NET_INET $2 } ) \
		exit(1)
	if ( ! { validate NET_INET $3 } ) \
		exit(1)
	exit(0)
	breaksw
case USER_NAME :
	if ( $#argv != 2 ) \
		exit(1)
	echo $2 | grep -s -w  '^[a-zA-Z][a-zA-Z0-9]*$'
	if ( $status != 0 ) \
		exit(2)
	exit(0)
	breaksw
case USER_GROUP :
	if ( $#argv != 2 ) \
		exit(1)
	echo $2 | grep -s -w  '^[a-zA-Z][a-zA-Z0-9]*$'
	if ( $status != 0 ) \
		exit(2)
	exit(0)
	breaksw
case USER_HOME :
	if ( $#argv != 2 ) \
		exit(1)
	echo $2 | grep -s -w  '^[/a-zA-Z][/a-zA-Z0-9]*$'
	if ( $status != 0 ) \
		exit(2)
	exit(0)
	breaksw
case USER_SHELL :
	if ( $#argv != 2 ) \
		exit(1)
	echo $2 | grep -s -w  '^[/a-zA-Z][/a-zA-Z0-9]*$'
	if ( $status != 0 ) \
		exit(2)
	exit(0)
	breaksw
default :
	echo "$0 can't validate a $1"
	exit(1)
	breaksw
endsw
#
# how did we get here? - must be a missinf "breaksw" somewhere.
#
echo "OOPS - fatal error in $0"
exit(1)
