#! /bin/csh -f
#
# given the new net_info in $1, rebuild rc.local, hosts, and local-data
#
if ( ! $?ADM_DIR ) \
	set ADM_DIR = /usr/lib/admin
set path	=	($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc /usr/ucb)
set DATA	=	$ADM_DIR/local-data
set TMP		=	$ADM_DIR/tmp
set NEWINFO	=	$1

#### set verbose
#### echo $0

cd $TMP
cp /etc/rc.local rc.local$$
cp /etc/hosts hosts$$
ex - rc.local$$ << 'EOFEOFEOF'
/^if \[ -f \/etc\/bootd/;/^fi$/d
w
q
'EOFEOFEOF'

set NET_CTLR = `grep '^NET_CTLR:[	 ]' $NEWINFO`
set NET_INET = `grep '^NET_INET:[	 ]' $NEWINFO`
set NET_DEST = `grep '^NET_DEST:[	 ]' $NEWINFO`
shift NET_CTLR
shift NET_INET
shift NET_DEST
cp /dev/null config.lines
cp /dev/null host.lines
cp /dev/null bootd.lines

set noglob

while ( $#NET_CTLR > 0 )
	set CTLR = $NET_CTLR[1]
	set INET = $NET_INET[1]
	set DEST = $NET_DEST[1]
	grep -v "ifconfig.*${CTLR}" < rc.local$$	\
	| grep -v "slattach.*${CTLR}" > tmp$$
	mv tmp$$ rc.local$$

	if ( $DEST == ETHER ) then
		echo "ifconfig ${CTLR} inet ${HOSTNAME}.${CTLR}"	\
		  >> config.lines
		cat "$ADM_DIR/misc/bootd_middle" >> bootd.lines
	else
		echo slattach ${CTLR} >> config.lines
		echo ifconfig $CTLR inet ${HOSTNAME}.${CTLR} $DEST	\
		  >> config.lines
	endif
	grep -v "$INET.*$HOSTNAME" < hosts$$ > hosts.x.$$
	mv hosts.x.$$ hosts$$
	echo "$INET	${HOSTNAME}.$CTLR $HOSTNAME" >> host.lines
	shift NET_CTLR
	shift NET_INET
	shift NET_DEST
end
cat host.lines >> hosts$$
#### cat config.lines rc.local$$ > tmp$$
ex - rc.local$$ << 'EOFEOFEOF'
/bin.*hostname/
.r config.lines
w
q
'EOFEOFEOF'
/bin/rm host.lines config.lines

set NETHER = `/usr/ucb/wc -l < bootd.lines`
if ( $NETHER > 0 ) then
	cat $ADM_DIR/misc/bootd_top bootd.lines $ADM_DIR/misc/bootd_bottom > x$$
	sed "/starting local daemons/r x$$" < rc.local$$ > tmp$$
	mv tmp$$ rc.local$$
	/bin/rm x$$ bootd.lines
	(cd /dev ; ./MAKEDEV enet0) >& /dev/null
endif
#
# Copy the new versions of rc.local and hosts to /etc
#
cp rc.local$$ /etc/rc.local ; rm rc.local$$
cp hosts$$ /etc/hosts ; rm hosts$$
cp $NEWINFO $DATA/net_info
exit(0)
