# /bin/csh -f
if ( ! $?ADM_DIR ) \
	set ADM_DIR = /usr/lib/admin
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)
setenv ADM_DATA $ADM_DIR/local-data
setenv ADM_TMP $ADM_DIR/tmp


start:
set noglob

set HOSTNAME = `cat $ADM_DATA/hostname`
set OLD_NET_CTLR = `grep '^NET_CTLR:[	 ]' $ADM_DATA/net_info`
set OLD_NET_INET = `grep '^NET_INET:[	 ]' $ADM_DATA/net_info`
set OLD_NET_DEST = `grep '^NET_DEST:[	 ]' $ADM_DATA/net_info`
shift OLD_NET_CTLR
shift OLD_NET_INET
shift OLD_NET_DEST

#
# get controller name
#
loop_ctlr:
echo ""
echo -n "Controller Name [<name> or xq?]:  "
set ANS_CTLR = `get_resp`
switch ( $ANS_CTLR )
	case _HELP_ :
		adm_help NET_CTLR
		goto loop_ctlr
		breaksw
	case [QqXx] :
		exit(0)
		breaksw
endsw
if ( ! { validate NET_CTLR $ANS_CTLR } ) \
	goto loop_ctlr
set TMP = ( $OLD_NET_CTLR )
while ( $#TMP )
	if ( $TMP[1] == $ANS_CTLR ) then
		echo "Controller $ANS_CTLR is already configured."
		goto loop_ctlr
	endif
	shift TMP
end

#
# get inet address
#
loop_inet:
echo -n "Internet address for $ANS_CTLR [<addr> or xq?]: "
set ANS_INET = `get_resp`
switch ( $ANS_INET )
	case _HELP_ :
		adm_help NET_INET
		goto loop_inet
		breaksw
	case [QqXx] :
		exit(0)
		breaksw
endsw
if ( ! { validate NET_INET $ANS_INET } ) \
	goto loop_inet
if ( { InetInUse $ANS_INET } ) \
	goto loop_inet
set TMP = ( $OLD_NET_INET )
while ( $#TMP )
	if ( $TMP[1] == $ANS_INET ) then
		echo "Address $ANS_INET is already configured."
		goto loop_inet
	endif
	shift TMP
end

#
# get destination for serial-line link
#
loop_dest:
switch ( $ANS_CTLR )
case tty* :
	echo -n "Inet destination address for $ANS_CTLR [<addr> or xq?]: "
	set ANS_DEST = `get_resp`
	switch ( $ANS_INET )
		case _HELP_ :
			adm_help NET_DEST
			goto loop_dest
			breaksw
		case [QqXx] :
			exit(0)
			breaksw
	endsw
	if ( ! { validate NET_SLP $ANS_INET $ANS_DEST } )	\
		goto loop_dest
	set TMP = ( $OLD_NET_DEST )
	while ( $#TMP )
		if ( $TMP[1] == $ANS_DEST ) then
			echo "Destination $ANS_DEST is already in use."
			goto loop_dest
		endif
		shift TMP
	end
	breaksw
default :
	set ANS_DEST = ETHER
	breaksw
endsw

#
# Got valid info in ANS_CTLR, ANS_INET, ANS_DEST  -  add it into rc.local,
# hosts, local-data, and so on...
#

set NET_CTLR = ($OLD_NET_CTLR $ANS_CTLR)
set NET_INET = ($OLD_NET_INET $ANS_INET)
set NET_DEST = ($OLD_NET_DEST $ANS_DEST)

#### echo $NET_CTLR
#### echo $NET_INET
#### echo $NET_DEST

echo "NET_CTLR:	$NET_CTLR" > $ADM_TMP/net_info$$
echo "NET_INET:	$NET_INET" >> $ADM_TMP/net_info$$
echo "NET_DEST:	$NET_DEST" >> $ADM_TMP/net_info$$

change_NETWORK_doit $ADM_TMP/net_info$$

/bin/rm $ADM_TMP/net_info$$

exit(0)
