#! /bin/csh -f
#
# Variables -
#	HOSTNAME	Hostname
#	NET_CTLR[]	Array of network controllers
#	NET_INET[]	Array of internet addresses, matches up one-to-one
#			with elements of NET_CTLR[].
#	NET_DEST[]	Inet destination for point-to-point hookups.  This
#			is the "other end" of a serial line net controller.
#
if ( ! $?ADM_DIR ) \
	set ADM_DIR = /usr/lib/admin
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)
setenv ADM_DATA $ADM_DIR/local-data
setenv ADM_TMP $ADM_DIR/tmp

#
# save current info
#
cp $ADM_DATA/net_info	$ADM_TMP/net_info$$
cp /etc/rc.local	$ADM_TMP/rc.local$$
cp /etc/hosts		$ADM_TMP/hosts$$

start:

set HOSTNAME = `cat $ADM_DATA/hostname`
set NET_CTLR = `grep '^NET_CTLR:[	 ]' $ADM_DATA/net_info`
set NET_INET = `grep '^NET_INET:[	 ]' $ADM_DATA/net_info`
set NET_DEST = `grep '^NET_DEST:[	 ]' $ADM_DATA/net_info`
shift NET_CTLR
shift NET_INET
shift NET_DEST

echo ""
echo ""
printf "Currently Configured Network Interfaces\n\n"
printf "         %-10s %-15s %-15s\n" Interface Address Destination
printf "         %-10s %-15s %-15s\n" --------- ------- -----------
@ n = 1
while ( $n <= $#NET_CTLR )
	printf "[%d]      %-10s %-15s %-15s\n" $n $NET_CTLR[$n] $NET_INET[$n] $NET_DEST[$n]
	@ n ++
end

echo ""
echo ""
echo "Commands:"
echo "	A	to add a new entry"
echo "	ABORT	to abort this session with no changes"
echo "	X or Q	to accept the current displayed entries and quit"
echo "	?	for help"
echo ""
echo -n "Enter command [daqx? or abort]..."
set ans = `get_resp`
switch ( $ans )
	case [QqXx] :
		exit(0)
		breaksw
	case _HELP_ :
		adm_help CHANGE_NETWORK
		goto start
		breaksw
	case [Aa][Bb][Oo][Rr][Tt] :
		exit(1)
		breaksw
	case [Aa] :
		goto add
		breaksw
	default :
		echo ""
		echo ""
		echo "Invalid entry..."
		goto start
		breaksw
endsw

add:
if ( ! { change_NETWORK_add } ) \
	goto restore_old_info
goto start

restore_old_info:
cp $ADM_TMP/net_info$$ $ADM_DATA/net_info
cp $ADM_TMP/rc.local$$ /etc/rc.local
cp $ADM_TMP/hosts$$ /etc/hosts
goto start
