#! /bin/csh -f
#
# Name:
#	 Rhost
#
# syntax:
#
#	 Rhost <newhost> <network ctlr> <GRAPHICS/NOGRAPHICS>
#
# Description:
#
#	for each file listed in PrivateFiles, do:
#		mv file .file.
#		link file -> .file.$RHOST
#		create .file.<newhost>
#
# Assumptions:
#	1. $ADM_DIR/misc/PrivateFiles has current list of files to be treated.
#
#
if ( ! $?ADM_DIR ) \
	set ADM_DIR = /usr/lib/admin
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)

set HOST = $1
set CTLR = $2
if ( $3 == GRAPHICS ) then
	set GRAPHICS = 1
else
	set GRAPHICS = 0
endif
set FILES = ( `cat $ADM_DIR/misc/PrivateFiles` )

foreach f ( $FILES )
	if ( ! -e $f ) then
		echo $f not found
	else
		set head = $f:h
		set tail = $f:t
		if ( $head == $tail ) then
			set hidden = .${head}.
		else
			set hidden = ${head}/.${tail}.
		endif

#
# change original name to hidden name (foo to .foo.) and create the
# symbolic link (foo -> .foo.$RHOST).
#
		if ( ! -e $hidden ) then
			mv $f $hidden
			if ($status != 0) then
				echo "Unknown problem encountered in executing the command"
				echo "	mv $f $hidden"
				echo "Be sure to check this after exiting from Admin."
				echo -n "Type RETURN to proceed..."
				set dummy = ($<)
			endif
			ln -s ${hidden}\$RHOST $f
			if ($status != 0) then
				echo "Unknown problem encountered in executing the command"
				echo "	"ln -s ${hidden}\$RHOST $f
				echo "Be sure to check this after exiting from Admin."
				echo -n "Type RETURN to proceed..."
				set dummy = ($<)
			endif
		endif
#
# create remotely owned version (.foo.<newhost> )
# If foo was a directory then create a directory else an empty file.
#
#		if ( ! -e ${hidden}${HOST} ) then
#			if ( -d $hidden ) then
#				mkdir ${hidden}${HOST}
#			else
#				cp /dev/null ${hidden}${HOST}
#			endif
#		endif
	endif
end

#
# Creation of private versions is done one at a time instead of in the loop
# above (as in previous versions) because of the number of special cases.
# /usr/spool, /usr/lib/mail
#

#
# private /dev
#
create drwxr-xr-x root wheel /.dev.$HOST
ln -s /.dev./MAKEDEV /.dev.${HOST}/MAKEDEV
(cd /.dev.$HOST ; ./MAKEDEV diskless std pty0)
if ( $GRAPHICS == 1 ) then
	(cd /.dev.$HOST ; ./MAKEDEV diskless ttyw0)
endif

#
# private /etc/fstab
#
create -rw-r--r-- root wheel /etc/.fstab.${HOST}

#
# private /etc/syslog.{conf,pid}
#
create -rw-r--r-- root wheel /etc/.syslog.conf.${HOST} \
  ${ADM_DIR}/misc/syslog.conf.diskless
create -rw-r--r-- root wheel /etc/.syslog.pid.${HOST}

#
# private /usr/lib/crontab
#
create -rw-rw-r-- root wheel /usr/lib/.crontab.${HOST} \
  ${ADM_DIR}/misc/crontab.diskless

#
# private /tmp and /usr/tmp
#
create drwxrwxrwx root wheel /.tmp.$HOST
create drwxrwxrwx root wheel /usr/.tmp.$HOST

#
# private /etc/motd
#
create -rw-r--r-- root staff /etc/.motd.$HOST

#
# private /etc/ttys
#
if ( $GRAPHICS == 1 ) then
	create -rw-r--r-- root staff /etc/.ttys.$HOST	\
	  ${ADM_DIR}/misc/ttys.diskless.graphics
else
	create -rw-r--r-- root staff /etc/.ttys.$HOST	\
	  ${ADM_DIR}/misc/ttys.diskless.nographics
endif

#
# private /etc/printcap
#
create -rw-rw-r-- root staff /etc/.printcap.${HOST}	\
    $ADM_DIR/misc/printcap.diskless
ed - /etc/.printcap.${HOST} << EOF_EOF_EOF
/SERVER/s//${HOSTNAME}/
w
q
EOF_EOF_EOF

#
# private /usr/adm
#
create drwxrwxr-x root staff  /usr/.adm.${HOST}
create -rw-r--r-- root staff  /usr/.adm.${HOST}/acct
create -rw-r--r-- uucp daemon /usr/.adm.${HOST}/aculog
create -rwxr-xr-x root staff  /usr/.adm.${HOST}/daily   /usr/adm/daily
create -rw-r--r-- root staff  /usr/.adm.${HOST}/lastlog
create -rw-r--r-- root staff  /usr/.adm.${HOST}/lpd-errs
create -rw-r--r-- root staff  /usr/.adm.${HOST}/messages
create -rwxr-xr-x root staff  /usr/.adm.${HOST}/monthly /usr/adm/monthly
create -rw-r--r-- root staff  /usr/.adm.${HOST}/msgbuf
create -rwxr-xr-x root staff  /usr/.adm.${HOST}/weekly  /usr/adm/weekly
create -rw-r--r-- root staff  /usr/.adm.${HOST}/wtmp

#
# private /usr/lib/mail
#
create drwxr-xr-x root staff /usr/lib/.mail.${HOST}
create -rw-r--r-- root staff /usr/lib/.mail.${HOST}/aliases	\
    ${ADM_DIR}/misc/aliases.diskless
create -rw-r--r-- root staff /usr/lib/.mail.${HOST}/ether.hosts
create -rw-r--r-- root staff /usr/lib/.mail.${HOST}/uucp.local
create -rw-r--r-- root staff /usr/lib/.mail.${HOST}/sendmail.cf \
    ${ADM_DIR}/misc/sendmail.cf.diskless
create -rw-r--r-- root staff /usr/lib/.mail.${HOST}/sendmail.hf \
    ${ADM_DIR}/misc/sendmail.hf.diskless
create -rw-r--r-- root staff /usr/lib/.mail.${HOST}/sendmail.fc
create -rw-r--r-- root staff /usr/lib/.mail.${HOST}/sendmail.st

#
# private /usr/spool
#
create drwxr-xr-x root   staff  /usr/.spool.${HOST}

create drwxr-xr-x daemon daemon /usr/.spool.${HOST}/at
create drwxr-xr-x daemon daemon /usr/.spool.${HOST}/at/past
create -rw-rw-r-- daemon daemon /usr/.spool.${HOST}/at/lasttimedone

create drwxrwxrwx root   wheel  /usr/.spool.${HOST}/mail
create drwxr-xr-x root   wheel  /usr/.spool.${HOST}/rwho
create drwxrwxr-x daemon daemon /usr/.spool.${HOST}/lpd
create drwxrwxrwx root   wheel  /usr/.spool.${HOST}/locks

create drwxrwxrwx root   wheel  /usr/.spool.${HOST}/mqueue
create -rw-r--r-- daemon staff  /usr/.spool.${HOST}/mqueue/syslog
create -rw-r--r-- daemon staff  /usr/.spool.${HOST}/mqueue/syslog.0
create -rw-r--r-- daemon staff  /usr/.spool.${HOST}/mqueue/syslog.1
create -rw-r--r-- daemon staff  /usr/.spool.${HOST}/mqueue/syslog.2
create -rw-r--r-- daemon staff  /usr/.spool.${HOST}/mqueue/syslog.3
create -rw-r--r-- daemon staff  /usr/.spool.${HOST}/mqueue/syslog.4
create -rw-r--r-- daemon staff  /usr/.spool.${HOST}/mqueue/syslog.5
create -rw-r--r-- daemon staff  /usr/.spool.${HOST}/mqueue/syslog.6
create -rw-r--r-- daemon staff  /usr/.spool.${HOST}/mqueue/syslog.7

create drwxrwxr-x uucp   daemon /usr/.spool.${HOST}/uucp
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/XTMP
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/CORRUPT
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/AUDIT
create drwxrwxrwx uucp   daemon /usr/.spool.${HOST}/uucp/LCK
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/LOG
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/LOG/uucico
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/LOG/uux
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/LOG/uuxqt
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/LOG/uucp
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/LOG/xferstats
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/STST
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/C.
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/D.${HOST}X
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/D.${HOST}
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/D.
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/X.
create drwxr-xr-x uucp   daemon /usr/.spool.${HOST}/uucp/TM.
create -rw-r--r-- uucp   daemon /usr/.spool.${HOST}/uucp/LOGFILE
create -rw-r--r-- root   daemon /usr/.spool.${HOST}/uucp/ERRLOG
create drwxrwxrwx uucp   daemon /usr/.spool.${HOST}/uucppublic
create -rw-r--r-- root   daemon /usr/.spool.${HOST}/uucppublic/.hushlogin

#
# private /vmunix
#
create lrwxrwxrwx root wheel /.vmunix.${HOST} '->' /usr/vmunix.${HOST}

exit(0)
