#! /bin/csh -f
if ( ! $?ADM_DIR ) \
	set ADM_DIR = /usr/lib/admin
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)

nameloop:
echo ""
echo ""
echo -n "Enter the name of the diskless node to delete...(? for help, [qx] to abort)..."
set NAME = `get_resp`
switch ( $NAME )
	case [QqXx] :
		exit(0)
		breaksw
	case _HELP_ :
		adm_help DISKLESS_NAME
		goto nameloop
		breaksw
	default :
		if ( ! { validate HOSTNAME $NAME } )	\
			goto nameloop
		goto gotname
		breaksw
endsw
gotname:

set FILES=( `cat $ADM_DIR/misc/PrivateFiles` )

foreach f ( $FILES )
	set head = $f:h
	set tail = $f:t
	if ( $head == $tail ) then
		set hidden = .${head}.$NAME
	else
		set hidden = ${head}/.${tail}.$NAME
	endif
	if (-e $hidden) then
		/bin/rm -rf $hidden
	else
		echo "Can't find $hidden"
	endif
end
