#! /bin/csh -f
if ( ! $?ADM_DIR ) \
	set ADM_DIR = /usr/lib/admin
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)
set TMP = $ADM_DIR/tmp
set noglob

#
# silent mode
#
if ( $1 == "-s" ) then
	grep -s "^[	 ]*$2" /etc/hosts
	if ( $status == 0 ) then
		exit(0)
	else
		exit(1)
	endif
endif

#
# verbose mode
#
grep "^[	 ]*$1" /etc/hosts >> $TMP/names$$
if ( $status == 0 ) then
again:
	echo ""
	echo ""
	echo "The following entry(s) already exist in the host file:"
	echo ""
	cat $TMP/names$$
	echo ""
	echo "Do you want it (them) removed so they can be re-used now?"
	echo "NOTE - if you answer yes, you should be certain that there"
	echo "are no machines on the network currently using these names"
	echo "or addresses."
	echo ""
	echo -n "Remove entry(s) from the hostfile [yn]?   "
	set ans = `get_resp`
	switch ( $ans )
		case [Yy] :
			grep -v -w "^[ 	]*$1" /etc/hosts > $ADM_DIR/tmp/tmp$$
			/bin/rm -f /etc/hosts
			mv $TMP/tmp$$ /etc/hosts
			exit(1)
			breaksw
		case [Nn] :
			exit(0)
			breaksw
		default :
			echo "Please answer 'y' or 'n'..."
			goto again
			breaksw
	endsw
else
	exit(1)
endif
