#! /bin/csh -f
#
# Variables -
#	HOSTNAME	Hostname
#	NET_CTLR[]	Array of network controllers
#	NET_INET[]	Array of internet addresses, matches up one-to-one
#			with elements of NET_CTLR[].
#	NET_DEST[]	Inet destination for point-to-point hookups.  This
#			is the "other end" of a serial line net controller.
#	P_MODE		Type of user account administration to do - legal values
#			are LOCAL, TCP, or YP.
#	TCP_PWD_MASTER	Name of some other machine on the net that is
#			considered to have "master" passwd and group files.
#			Valid only if P_MODE == TCP.
#
if ( ! $?ADM_DIR ) \
	set ADM_DIR = /usr/lib/admin
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)
setenv ADM_DATA $ADM_DIR/local-data

start:

echo ""
echo ""
echo ""
set HOSTNAME = `cat $ADM_DATA/hostname`
set P_MODE = `cat $ADM_DATA/p_mode`
switch ( $P_MODE )
	case LOCAL :
		breaksw
	case TCP :
		set TCP_P_SERVER = `cat $ADM_DATA/tcp_p_server`
		if ( $TCP_P_SERVER == "" ) \
			set TCP_P_SERVER = "-NONE-"
		breaksw
	case YP :
		breaksw
endsw
set NET_CTLR = `grep '^NET_CTLR:[	 ]' $ADM_DATA/net_info`
set NET_INET = `grep '^NET_INET:[	 ]' $ADM_DATA/net_info`
set NET_DEST = `grep '^NET_DEST:[	 ]' $ADM_DATA/net_info`
shift NET_CTLR
shift NET_INET
shift NET_DEST

printf "[1]  Hostname:          %s\n\n" $HOSTNAME
printf "[2]  User Account Mode: %s\n\n" $P_MODE
if ( $P_MODE == TCP ) then
	printf "[3]  Password Master:   %s\n\n" $TCP_P_SERVER
else
	printf "\n\n"
endif
printf "[4]  Network Configuration\n\n"
printf "         %-10s %-15s %-15s\n" Interface Address Destination
printf "         %-10s %-15s %-15s\n" --------- ------- -----------
@ n = 1
while ( $n <= $#NET_CTLR )
	printf "         %-10s %-15s %-15s\n" $NET_CTLR[$n] $NET_INET[$n] $NET_DEST[$n]
	@ n ++
end

echo ""
echo ""
echo -n "Enter number of item to modify, ? for help, or x to exit..."
set ans = `get_resp`
switch ( $ans )
	case [QqXx] :
		exit(0)
		breaksw
	case _HELP_ :
		adm_help ADMIN_PARAMS
		goto start
		breaksw
	case 1 :
		goto hostname_change
		breaksw
	case 2 :
		change_PMODE
		goto start
		breaksw
	case 3 :
		if ( $P_MODE == TCP ) then
			change_TCP_P_SERVER
		else
			echo ""
			echo "Invalid entry..."
			echo ""
		endif
		goto start
		breaksw
	case 4 :
		change_NETWORK
		goto start
		breaksw
	default :
		echo ""
		echo "Invalid entry..."
		echo ""
		goto start
		breaksw
endsw
exit(0)

##
##
##

hostname_change:
echo ""
echo ""
echo "Renaming the system requires that you bring the system to single user,"
echo "and will require re-running all the admin initialization.  Do you wish"
echo -n "to continue [ynx?]..."
set ans = `get_resp`
switch ( $ans )
	case [Xx] :
		exit(0)
		breaksw
	case [Yy] :
		goto last_chance
		breaksw
	case [Nn] :
		goto start
		breaksw
	case _HELP_ :
		adm_help RENAME
		goto hostname_change
		breaksw
	default :
		echo ""
		echo ""
		echo "Invalid response - please answer one of [ynx?]..."
		echo ""
		echo ""
		goto hostname_change
		breaksw
endsw

last_chance:
echo ""
echo ""
echo "Last chance - if you respond in the affirmative the current admin data"
echo "base will be erased.  You will have to re-run the admin initialization"
echo "before admin's normal functions can be used again.  Do you REALLY want"
echo -n "to continue [yn]?..."
set ans = `get_resp`
if ( $ans == y || $ans == Y ) then
	/bin/rm -rf $ADM_DIR/local-data
	exec $ADM_PROG
else
	goto start
endif

#
# change TCP user account server
#
pwd_server_change:
cp $ADM_DATA/tcp_p_server $ADM_DIR/tmp/tcp_p_server$$
if ( ! { change_TCP_P_SERVER } ) then
	mv $ADM_DIR/tmp/tcp_p_server$$ $ADM_DATA/tcp_p_server
endif
goto start
