#! /bin/csh
#
#
#
if ( ! $?ADM_DIR ) \
	set ADM_DIR = /usr/lib/admin
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)
set TMP = $ADM_DIR/tmp
set DATA = $ADM_DIR/local-data
set MISC = $ADM_DIR/misc

set HOSTNAME	=	`cat $DATA/hostname`
set P_MODE	=	`cat $DATA/p_mode`
set TCP_P_SERVER =	`cat $DATA/tcp_p_server`

cp /etc/passwd	$TMP/passwd
awk '-F:' '{print $1}' $TMP/passwd > $TMP/namelist
awk '-F:' '{print $3}' $TMP/passwd | sort -n > $TMP/uidlist
cp /etc/group	$TMP/group
awk '-F:' '{print $1}' $TMP/group > $TMP/grouplist
cp /usr/lib/mail/aliases $TMP/aliases
sed -n '/^[a-zA-Z].*:/s/:.*//' $TMP/aliases > $TMP/aliaslist



#
# get user name
#
nameloop:
echo ""
echo -n "New user name   [<name> qx?]..."
set NAME = `get_resp`
switch ( $NAME )
case _HELP_ :
	adm_help USER_NAME
	goto nameloop
	breaksw
case [QqXx] :
	exit(0)
	breaksw
default:
	if ( ! { validate USER_NAME $NAME } ) \
		goto nameloop
	if ( { grep -w -s $NAME $TMP/namelist } ) then
		echo ""
		echo "Login $NAME already exists in the password file.  Either choose"
		echo "another login name for the new user, or delete the old"
		echo "login for that name before installing the new one."
		echo ""
		goto nameloop
	endif
	breaksw
endsw

#
# get group for $NAME
#
grouploop:
echo ""
echo -n "New users group  [<name> qx?]..."
set GROUP = `get_resp`
switch ( $GROUP )
case _HELP_ :
	adm_help USER_GROUP
	goto grouploop
	breaksw
case [QqXx] :
	exit(0)
	breaksw
default:
	if ( ! { validate USER_GROUP $GROUP } ) \
		goto nameloop
	if ( ! { grep -s $GROUP $TMP/grouplist } ) then
		echo ""
		echo "Group $GROUP does not exist in the group file.  Either"
		echo "chose another group for the user $NAME or add the desired"
		echo "new group before proceeding with this user name."
		echo ""
		goto grouploop
	endif
	breaksw
endsw
set GID = `grep "^$GROUP" < $TMP/group | awk '-F:' '{print $3}'`

#
# real life
#
reallifeloop:
echo -n "In real life [<info> qx?]..."
set REALLIFE = ( `get_resp -m` )
if ( $#REALLIFE > 1 ) then
	set XXX = $REALLIFE[1]
else
	set XXX = $REALLIFE
endif
switch ( $XXX )
case _HELP_ :
	adm_help USER_REALLIFE
	goto reallifeloop
	breaksw
case [QqXx] :
	exit(0)
	breaksw
default:
	breaksw
endsw

#
# home directory
#
homeloop:
echo -n "Home directory [<dir> qx? or <return> for /u/$NAME]..."
set HOME = `get_resp`
switch ( $HOME )
case "" :
	set HOME = "/u/$NAME"
	breaksw
case _HELP_ :
	adm_help USER_HOMEDIR
	goto reallifeloop
	breaksw
case [QqXx] :
	exit(0)
	breaksw
default:
	if ( ! { validate USER_HOMEDIR $HOME } ) \
		goto homeloop
	breaksw
endsw

#
# shell
#
shellloop:
echo -n "Shell [<shell> qx? or <return> for /bin/csh]..."
set SHELL = `get_resp`
switch ( $SHELL )
case "" :
	set SHELL = "/bin/csh"
	breaksw
case _HELP_ :
	adm_help USER_SHELL
	goto reallifeloop
	breaksw
case [QqXx] :
	exit(0)
	breaksw
default:
	if ( ! { validate USER_SHELL $SHELL } ) \
		goto shellloop
	breaksw
endsw

#
# make unique uid
#
set UID = `( awk '{ if ( 100 <= $1 && $1 <= 9999 ) print $1 }' $TMP/uidlist | /usr/ucb/tail -1 )`
@ UID ++

set PASSWORD = newuser
echo ""
echo ""
echo "Data entered :"
echo ""
echo "	Login          =  $NAME"
echo "	Group          =  $GROUP"
echo "	Real life      =  $REALLIFE"
echo "	Home directory =  $HOME"
echo "	Shell          =  $SHELL"
echo "	Uid            =  $UID"
echo "	Initial Passwd =  $PASSWORD"
echo ""
echo -n "Is this correct [y to accept, anything else to reject]..."
set ans = `get_resp`
switch ( $ans )
	case [Yy] :
		goto doit
		breaksw
	default :
		goto nameloop
		breaksw
endsw

doit:
echo ""
set DOTLIST = ".login .cshrc .logout"
echo "==== adding $NAME to /etc/passwd"
newpw $NAME $PASSWORD $UID $GID "$REALLIFE" $HOME $SHELL >> /etc/passwd
echo "==== creating $HOME"
mkdir $HOME
(cd $MISC ; tar cf - ${DOTLIST} ) | (cd $HOME ; tar xf - )
chown -R $NAME $HOME
chgrp -R $GROUP $HOME
exit(0)
