#! /bin/csh -f
if ( ! $?ADM_DIR ) \
	set ADM_DIR = /usr/lib/admin
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)

set noglob

set TYPE = $1
set HOSTNAME = `cat $ADM_DIR/local-data/hostname`
#
# make sure the server has some interface available.
#
if ( $TYPE == cluster ) then
	set VB_IF = `grep -v '^#' /etc/hosts | grep -w ${HOSTNAME}.vb0`
	if ( $status != 0 ) \
		goto no_vb
	set INET = `NextNetAddress $VB_IF`
else
	grep -s 'NET_DEST.*ETHER' $ADM_DIR/local-data/net_info
	if ( $status != 0 ) \
		goto no_ether
endif

#
# get name of the new node
#
nameloop:
echo ""
echo ""
echo -n "Enter the name of the new $TYPE node...(? for help, [qx] to abort)..."
set NAME = `get_resp`
switch ( $NAME )
	case [QqXx] :
		exit(0)
		breaksw
	case _HELP_ :
		adm_help DISKLESS_NAME
		goto nameloop
		breaksw
	default :
		if ( ! { validate HOSTNAME $NAME } )	\
			goto nameloop
		if ( { NameInUse $NAME } )	\
			goto nameloop
		goto gotname
		breaksw
endsw
gotname:

#
# get net address for new node
#
inetloop:
if ( $TYPE == cluster ) \
	goto gotinet
echo ""
echo ""
echo -n "Internet address for $NAME...(? for help, [qx] to abort)..."
set INET = `get_resp`
switch ( $INET )
	case [QqXx] :
		exit(0)
		breaksw
	case _HELP_ :
		adm_help DISKLESS_INET
		goto inetloop
		breaksw
	default :
		if ( ! { validate NET_INET $INET } ) \
			goto inetloop
		if ( { InetInUse $INET } )	\
			goto inetloop
		goto gotinet
		breaksw
endsw
gotinet:

#
# See what kind of interface it has.
#
if ( $TYPE == cluster ) then
	set CTLR = vb0
else
	ifaceloop:
	echo ""
	echo ""
	echo -n "Enter the name of the Ethernet controller on $NAME (? for help, [qx] to abort)..."
	set CTLR = `get_resp`
	switch ( $CTLR )
		case [QqXx] :
			exit(0)
			breaksw
		case _HELP_ :
			adm_help NET_CTLR
			goto ifaceloop
			breaksw
		default :
			if ( ! { validate ETHER_CTLR $CTLR } ) \
				goto ifaceloop
			goto gotiface
			breaksw
	endsw
gotiface:
endif

#
# graphics?
#
grloop:
echo ""
echo ""
echo -n "Is $NAME a graphics system? [ynq?]  "
set ans = `get_resp`
switch ( $ans )
	case [Yy] :
		set GRAPHICS = GRAPHICS
		breaksw
	case [Nn] :
		set GRAPHICS = NOGRAPHICS
		breaksw
	case [QqXx] :
		exit(0)
		breaksw
	case _HELP_ :
		adm_help DISKLESS_GRAPHICS
		goto grloop
		breaksw
	default :
		echo "Invalid response...please answer one of [ynq or ?]..."
		goto grloop
		breaksw
endsw
#
# OK, we have all we need.  Modify the host file and set up the special
# directories and files.
#
echo ""
echo "The following line will be added to the host file.  Note the name and"
echo "internet address in your System Administrator Guide for future reference:"
echo ""
echo "	$INET     $NAME ${NAME}.${CTLR}"
echo ""
echo -n "Press <return> to continue..."
set dummy = ($<)
echo ==== updating host file
echo "$INET	$NAME ${NAME}.${CTLR}" >> /etc/hosts
echo ==== checking diskless swap area ====
if ( ! -d /usr/spool/diskless ) then
	if ( -e /usr/spool/diskless ) then
		rm -f /usr/spool/diskless
	endif
	mkdir /usr/spool/diskless
	chmod 700 /usr/spool/diskless
endif
echo ==== creating private files and directories
Rhost $NAME $CTLR $GRAPHICS
exit(0)

#
# Need to configure some interface for server interface...
#
no_vb:
echo "The vb interface is not configured in /etc/hosts.  This configuration may be"
echo "done by selecting the MODIFY ADMIN PARAMETERS option from the admin top"
echo "menu, then selecting the option to modify network interfaces from the next"
echo -n "menu.   Type <return> to continue..."
set dummy = `get_resp`
exit(0)

no_ether:
echo "There is no ethernet interface configured on this machine.  This"
echo "configuration may be done by selecting the MODIFY ADMIN PARAMETERS"
echo "option from the admin top menu, then selecting the option to modify"
echo -n "network interfaces from the next menu.   Type <return> to continue..."
set dummy = `get_resp`
exit(0)
