/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
/*
static char sccsid[] = "@(#)calls.c	5.1 (Berkeley) 6/4/85";
*/
static char *sccsid = "@(#)calls.c	1.1 (NBI) 6/11/85";
#endif not lint

#include	"gprof.h"

    /*
     * This file is needed for the -c option of gprof.
     */

    /*
     *	a namelist entry to be the child of indirect calls
     */
nltype	indirectchild = {
	"(*)" ,				/* the name */
	(unsigned long) 0 ,		/* the pc entry point */
	(unsigned long) 0 ,		/* entry point aligned to histogram */
	(double) 0.0 ,			/* ticks in this routine */
	(double) 0.0 ,			/* cumulative ticks in children */
	(long) 0 ,			/* how many times called */
	(long) 0 ,			/* how many calls to self */
	(double) 1.0 ,			/* propagation fraction */
	(double) 0.0 ,			/* self propagation time */
	(double) 0.0 ,			/* child propagation time */
	(bool) 0 ,			/* print flag */
	(int) 0 ,			/* index in the graph list */
	(int) 0 , 			/* graph call chain top-sort order */
	(int) 0 ,			/* internal number of cycle on */
	(struct nl *) &indirectchild ,	/* pointer to head of cycle */
	(struct nl *) 0 ,		/* pointer to next member of cycle */
	(arctype *) 0 ,			/* list of caller arcs */
	(arctype *) 0 			/* list of callee arcs */
    };

operandenum
operandmode( instp )
    unsigned short	*instp;
{
    switch ( (*instp >> 3) & 07 ) {
	case 0:
	    return dreg;
	case 1:
	    return areg;
	case 2:
	    return areg_indir;
	case 3:
	    return areg_postinc;
	case 4:
	    return areg_predec;
	case 5:
	    return areg_disp;
	case 6:
	    return areg_index;
	case 7:
	    switch ( *instp & 07 ) {
		case 0:
		    return abs_short;
		case 1:
		    return abs_long;
		case 2:
		    return pc_disp;
		case 3:
		    return pc_index;
		case 4:
		    return immed;
		default:
		    return illegal;
	    }
    }
    /* NOTREACHED */
}

char *
operandname( mode )
    operandenum	mode;
{
    
    switch ( mode ) {
	case dreg:
	    return "D register";
	case areg:
	    return "A register";
	case areg_indir:
	    return "A register indirect";
	case areg_postinc:
	    return "A register indirect w/postinc";
	case areg_predec:
	    return "A register indirect w/predec";
	case areg_disp:
	    return "A register indirect w/displacement";
	case areg_index:
	    return "A register indirect w/index";
	case abs_short:
	    return "absolute short";
	case abs_long:
	    return "absolute long";
	case pc_disp:
	    return "PC register indirect w/displacement";
	case pc_index:
	    return "PC register indirect w/index";
	case immed:
	    return "immediate";
    }
    /* NOTREACHED */
}

unsigned long
reladdr( instp )
    unsigned short	*instp;
{
    operandenum	mode = operandmode( instp );
    short	*sp;
    long	*lp;

    instp += 1;			/* skip over the instruction */
    switch ( mode ) {
	default:
	    fprintf( stderr , "[reladdr] not relative address\n" );
	    return (unsigned long) instp;
	case pc_disp:
	    sp = (short *) instp;
	    return (unsigned long) ( (int) instp + *sp );
	case abs_short:
	    sp = (short *) instp;
	    return (unsigned long) ( *sp );
	case abs_long:
	    lp = (long *) instp;
	    return (unsigned long) ( *lp );
    }
}

findcalls( parentp , p_lowpc , p_highpc )
    nltype		*parentp;
    unsigned long	p_lowpc;
    unsigned long	p_highpc;
{
    unsigned short	*instructp;
    long		length;
    nltype		*childp;
    operandenum		mode;
    unsigned long	destpc;
    int			disp;

    if ( textspace == 0 ) {
	return;
    }
    if ( p_lowpc < s_lowpc ) {
	p_lowpc = s_lowpc;
    }
    if ( p_highpc > s_highpc ) {
	p_highpc = s_highpc;
    }
#   ifdef DEBUG
	if ( debug & CALLSDEBUG ) {
	    printf( "[findcalls] %s: 0x%x to 0x%x\n" ,
		    parentp -> name , p_lowpc , p_highpc );
	}
#   endif DEBUG
    for (   instructp = (unsigned short *) (textspace + p_lowpc) ;
	    instructp < (unsigned short *) (textspace + p_highpc) ;
	    instructp += instlength( instructp ) ) {

	/* See if we might have a bsr instruction */
	if( (*instructp&BSR_M) == BSR ) {

#	    ifdef DEBUG
		if ( debug & CALLSDEBUG ) {
		    printf( "[findcalls]\t0x%x:bsr" , instructp - textspace );
		}
#	    endif DEBUG

	    /* bsr instruction has either 8, 16 or 32-bit displacement */

	    if( (disp = (char) (*instructp&BSR_DM)) == 0 ) {
		disp = *((short *) (instructp+1));
	    } else if( disp == (char)0xff) {
		disp = *((long *) (instructp+1));
	    }

	    /* figure out destination pc */
	    destpc = (((int)instructp) + 2) + disp - (int)textspace;

	    goto reg_addr;

	} else if( (*instructp&JSR_M) == JSR ) {
	/* See if we might have a jsr instruction */

#	    ifdef DEBUG
		if ( debug & CALLSDEBUG ) {
		    printf( "[findcalls]\t0x%X:jsr" , instructp - textspace );
		}
#	    endif DEBUG

	    mode = operandmode( instructp );
#	    ifdef DEBUG
		if ( debug & CALLSDEBUG ) {
		    printf( "\toperand is %s", operandname( mode ) );
		}
#	    endif DEBUG
	    switch ( mode ) {
		case areg_indir:
		case areg_disp:
		case areg_index:
		case pc_index:
			/*
			 *	indirect call: call through pointer
			 *	or pc relative indexed
			 */
		    addarc( parentp , &indirectchild , (long) 0 );
		    continue;
		case abs_short:
		case abs_long:
		case pc_disp:
			/*
			 *	regular addressing
			 *	check that this is the address of 
			 *	a function.
			 */
		    destpc = reladdr( instructp );

		reg_addr:
		    if ( destpc >= s_lowpc && destpc <= s_highpc ) {
			childp = nllookup( destpc );
			if ( childp -> value == destpc ) {
				/*
				 *	a hit
				 */
			    addarc( parentp , childp , (long) 0 );
			    continue;
			}
			goto botched;
		    }
			/*
			 *	else:
			 *	it looked like a call,
			 *	but it wasn't to anywhere.
			 */
		    goto botched;
		default:
		botched:
			/*
			 *	something funny going on.
			 */
#		    ifdef DEBUG
			if ( debug & CALLSDEBUG ) {
			    printf( "[findcalls]\tbut it's a botch\n" );
			}
#		    endif DEBUG
		    continue;
	    }
	}
    }
}
