#include <stdio.h>

/* disassemble text portion of an object file */
/* use here mostly to get instruction lengths for gprof -c use */

unsigned short *dot;

int omove(), obranch(), oimmed();
int oneop(), xoneop(), foneop();
int osize(), xsize(), opmode();

int instfetch ();

#define NILP 0
struct opdesc {
	unsigned short mask, match;
	int (*opfun) ();
	char *farg;
	int nbytes;
} opdecode[] =
{	/* order is important below */
	/* move instructions */
	0xF000, 0x1000, omove,	"b",	2,
	0xF000, 0x2000, omove,	"l",	2,
	0xF000, 0x3000, omove,	"w",	2,

	/* branches */
	0xF000, 0x6000, obranch, 0,	2,

	/* op class 0  */
	0xFFC0, 0x00C0, xoneop,	"chk2b",	4,
	0xFF00, 0x0000, oimmed,	"or",		2,
	0xFFC0, 0x02C0, xoneop,	"chk2w",	4,
	0xFF00, 0x0200, oimmed,	"and",		2,
	0xFFC0, 0x04C0, xoneop,	"chk2l",	4,
	0xFF00, 0x0400, oimmed,	"sub",		2,
	0xFFF8, 0x06C0, NILP,	"rtm",		2,
	0xFFF8, 0x06C8, NILP,	"rtm",		2,
	0xFFC0, 0x06C0, xoneop,	"callm",	4,
	0xFF00, 0x0600, oimmed,	"add",		2,
	0xFFFF, 0x0AFC, NILP,	"cas2b",	6,
	0xFFC0, 0x0AC0, xoneop,	"casb",		4,
	0xFF00, 0x0A00, oimmed,	"eor",		2,
	0xFFFF, 0x0CFC, NILP,	"cas2w",	6,
	0xFFC0, 0x0CC0, xoneop,	"casw",		4,
	0xFF00, 0x0C00, oimmed,	"cmp",		2,
	0xFFFF, 0x0EFC, NILP,	"cas2l",	6,
	0xFFC0, 0x0EC0, xoneop,	"casl",		4,
	0xFFC0, 0x0E00, xoneop,	"movesb",	4,
	0xFFC0, 0x0E40, xoneop,	"movesw",	4,
	0xFFC0, 0x0E80, xoneop,	"movesl",	4,
	0xF138, 0x0108, NILP,	"movep",	4,
	0xF100, 0x0100, oneop,	"bitop",	2,
	0xF800, 0x0800, xoneop,	"bitop",	2,

	/* op class 4 */
	0xFFC0, 0x40C0, oneop,	"mov sr,",	2,
	0xFF00, 0x4000, oneop,	"negx",		2,
	0xFFC0, 0x42C0, oneop,	"mov cc,",	2,
	0xFF00, 0x4200, oneop,	"clr",		2,
	0xFFC0, 0x44C0, oneop,	"mov ,cc",	2,
	0xFF00, 0x4400, oneop,	"neg",		2,
	0xFFC0, 0x46C0, oneop,	"mov ,sr",	2,
	0xFF00, 0x4600, oneop,	"not",		2,
	0xFFF8, 0x4808, NILP,	"link",		6,
	0xFFC0, 0x4800, oneop,	"nbcd",		2,
	0xFFF8, 0x4840, NILP,	"swap",		2,
	0xFFF8, 0x4848, NILP,	"bkpt",		2,
	0xFFC0, 0x4840, oneop,	"pea",		2,
	0xFFF8, 0x4880, NILP,	"extw",		2,
	0xFFF8, 0x48C0, NILP,	"extl",		2,
	0xFFF8, 0x49C0, NILP,	"extbl",	2,
	0xFB80, 0x4880, xoneop,	"movem",	4,
	0xFFC0, 0x4AC0, oneop,	"tas",		2,
	0xFF00, 0x4A00, oneop,	"tst",		2,
	0xFFC0, 0x4C00, xsize,	"l",		4,	/* mul */
	0xFFC0, 0x4C40, xsize,	"l",		4,	/* div */
	0xFFF0, 0x4E40, NILP,	"trap",		2,
	0xFFF8, 0x4E50, NILP,	"link",		4,
	0xFFF8, 0x4E58, NILP,	"unlk",		2,
	0xFFF8, 0x4E60, NILP,	"move ,sp",	2,
	0xFFF8, 0x4E68, NILP,	"move usp,",	2,
	0xFFFF, 0x4E70, NILP,	"reset",	2,
	0xFFFF, 0x4E71, NILP,	"nop",		2,
	0xFFFF, 0x4E72, NILP,	"stop",		4,
	0xFFFF, 0x4E73, NILP,	"rte",		2,
	0xFFFF, 0x4E74, NILP,	"rtd",		4,
	0xFFFF, 0x4E75, NILP,	"rts",		2,
	0xFFFF, 0x4E76, NILP,	"trapv",	2,
	0xFFFF, 0x4E77, NILP,	"rtr",		2,
	0xFFFE, 0x4E7A, NILP,	"movec",	4,
	0xFFC0, 0x4E80, oneop,	"jsr",		2,
	0xFFC0, 0x4EC0, oneop,	"jmp",		2,
	0xF1C0, 0x4180, osize,	"w",		2,	/* chkw */
	0xF1C0, 0x4100, osize,	"l",		2,	/* chkl */
	0xF1C0, 0x41C0, oneop,	"lea",		2,

	0xF0F8, 0x50C8, NILP,	"dbcc",		4,
	0xF0FF, 0x50FA, NILP,	"trapcc",	4,
	0xF0FF, 0x50FB, NILP,	"trapcc",	6,
	0xF0FF, 0x50FC, NILP,	"trapcc",	2,
	0xF0C0, 0x50C0, oneop,	"scc",		2,
	0xF100, 0x5000, oneop,	"addq",		2,
	0xF100, 0x5100, oneop,	"subq",		2,

	0xF000, 0x7000, NILP,	"moveq",	2,

	0xF1C0, 0x80C0, osize,	"w",		2,	/* divu */
	0xF1F0, 0x8100, NILP,	"sbcd",		2,
	0xF1F0, 0x8140, NILP,	"pack",		4,
	0xF1F0, 0x8180, NILP,	"unpk",		4,
	0xF1C0, 0x81C0, osize,	"w",		2,	/* divu */
	0xF000, 0x8000, opmode,	"or",		2,

	0xF1C0, 0x91C0, opmode,	"sub",		2,
	0xF130, 0x9100, NILP,	"subx",		2,
	0xF000, 0x9000, opmode,	"sub",		2,

	0xF1C0, 0xB1C0, opmode,	"cmp",		2,
	0xF138, 0xB108, NILP,	"cmpm",		2,
	0xF100, 0xB000, opmode,	"cmp",		2,
	0xF100, 0xB100, opmode,	"eor",		2,
	
	0xF1C0, 0xC0C0, osize,	"w",		2,	/* mulu */
	0xF1C0, 0xC1C0, osize,	"w",		2,	/* muls */
	0xF1F8, 0xC188, NILP,	"exg",		2,
	0xF1F8, 0xC148, NILP,	"exg",		2,
	0xF1F8, 0xC140, NILP,	"exg",		2,
	0xF1F0, 0xC100, NILP,	"abcd",		2,
	0xF000, 0xC000, opmode,	"and",		2,

	0xF1C0, 0xD1C0, opmode,	"add",		2,
	0xF130, 0xD100, NILP,	"addx",		2,
	0xF000, 0xD000, opmode,	"add",		2,

	0xF9C0, 0xE8C0, xoneop,	"bfops",	4,
	0xF9C0, 0xE9C0, xoneop,	"bfops",	4,
	0xF1C0, 0xE0C0, oneop,	"shiftr",	2,
	0xF100, 0xE000, NILP,	"shiftr",	2,
	0xF1C0, 0xE1C0, oneop,	"shiftl",	2,
	0xF100, 0xE100, NILP,	"shiftl",	2,

	0xFFFF, 0xF27A, NILP,	"ftrapcc",	6,
	0xFFFF, 0xF27B, NILP,	"ftrapcc",	8,
	0xFFFF, 0xF27C, NILP,	"ftrapcc",	4,
	0xFFF8, 0xF248, NILP,	"fdbcc",	6,
	0xFFC0, 0xF240, xoneop,	"fscc",		4,
	0xFFC0, 0xF280, NILP,	"fbccw",	4,
	0xFFC0, 0xF2C0, NILP,	"fbccl",	6,
	0xFFC0, 0xF300, oneop,  "fsave",	2,
	0xFFC0, 0xF340, oneop,  "frestore",	2,
	0xFE00, 0xF200, foneop,	"fops",		4,

	0, 0, 0, 0, 0
};


instlength (addr)
unsigned short *addr;
{
	register struct opdesc *p;
	register unsigned int inst;

	dot = addr;
	inst = instfetch (2);
	for (p = opdecode; p->mask; p++)
		if ((unsigned short) (inst & p->mask) == p->match) {
			if (p->opfun != NILP) {
				(*p->opfun) (inst, p->farg);
				return (dot - addr);
			} else
				return (p->nbytes >> 1);
		}

	/* did not find it in table, skip this word */
	return 1;
}

int
instfetch (size)
int size;
{
	register int ans;

	if (size == 4) {
		ans = *(int *)dot;
		dot += 2;
	} else {
		ans = *dot++;
	}
	return (ans);
}

mode_reg (mode, reg, size)
int mode, reg;
int size;
{
	int value, disp;

	switch (mode) {
	case 0: 
	case 1: 
	case 2: 
	case 3: 
	case 4: 
		break;
	case 5: 
		disp = instfetch (2);
		break;

	case 6: 
		indexwd (reg);
		break;

	case 7: 
		switch (reg) {
		case 0: 
			value = instfetch (2);
			break;

		case 1: 
			value = instfetch (4);
			break;

		case 2: 
			disp = instfetch (2);
			break;

		case 3: 
			indexwd (16);
			break;

		case 4: 
			if (size == 0) {
				/* Ooops! */
				/* this is patently wrong, but can happen
				 * when disassembling the address table
				 * following the code for the switch statement.
				 * ignore it as a non-error.
				 */
			} else if (size <= 2) {
				/* byte and word */
				value = instfetch (2);
			} else if (size == 4) {
				/* long word  and single precision */
				value = instfetch (4);
			} else if (size == 8) {
				/* double precision */
				value = instfetch (4);
				value = instfetch (4);
			} else if (size == 12) {
				/* extended precision and packed decimal */
				value = instfetch (4);
				value = instfetch (4);
				value = instfetch (4);
			}
			break;

		default: 
			break;
		}
		break;

	default: 
		break;
	}
}

eff_addr (inst)
int inst;
{
	mode_reg ((inst >> 3) & 07, inst & 07, 0);
}

union index_word {
	unsigned short word;
	struct {
		unsigned short isareg: 1;
		unsigned short reg: 3;
		unsigned short sz: 1;
		unsigned short scale: 2;
		unsigned short usefull: 1;
		unsigned short disp: 8;
	} brief;
	struct {
		unsigned short isareg: 1;
		unsigned short reg: 3;
		unsigned short sz: 1;
		unsigned short scale: 2;
		unsigned short usefull: 1;
		unsigned short bsupp: 1;
		unsigned short isupp: 1;
		unsigned short bdsize: 2;
		unsigned short zfill: 1;
		unsigned short ixsel: 3;
	} full;
};

indexwd (reg)
int reg;
{
	int bdisp, odisp;
	union index_word ixwd;

	ixwd.word = instfetch (2);
	if (!ixwd.brief.usefull) {
		return;
	}

	/* now comes the really groady part */

	switch (ixwd.full.bdsize) {
	case 0: 		/* this is really an error, but oh, well... */
	case 1: 
		bdisp = 0;
		break;
	case 2: 
		bdisp = instfetch (2);
		break;
	case 3: 
		bdisp = instfetch (4);
		break;
	}
	if (ixwd.full.ixsel != 0) {
		switch (ixwd.full.ixsel & ~04) {
		case 0: 	/* this is really an error, but oh, well... */
		case 1: 
			odisp = 0;
			break;
		case 2: 
			odisp = instfetch (2);
			break;
		case 3: 
			odisp = instfetch (4);
			break;
		}
	}
}

omove (inst, s)
int inst;
char *s;
{
	int size;

	size = ((*s == 'b') ? 1 : (*s == 'w') ? 2 : 4);
	mode_reg ((inst >> 3) & 07, inst & 07, size);
	mode_reg ((inst >> 6) & 07, (inst >> 9) & 07, size);
}

obranch (inst, dummy)
int inst;
{
	int disp = inst & 0377;
	int cond = (inst >> 8) & 017;

	if (disp == 0) {
		disp = instfetch (2);
	} else if (disp == 255) {
		disp = instfetch (4);
	}
}

opmode (inst, opcode)
int inst;
{
	register int mode = ((inst >> 6) & 07);
	int size;

	size = (mode == 0 || mode == 4) ? 1 :
		(mode == 1 || mode == 3 || mode == 5) ? 2 : 4;
	mode_reg ((inst >> 3) & 07, inst & 07, size);
}

mapsize (inst)
register int inst;
{
	inst >>= 6;
	inst &= 03;
	return ((inst == 0) ? 1 : (inst == 1) ? 2 : (inst == 2) ? 4 : -1);
}

oimmed (inst, opcode)
int inst;
{
	int size = mapsize (inst);
	int mode = (inst >> 3) & 07;
	int reg = inst & 07;
	int const;

	if (size > 0) {
		const = instfetch (size == 4 ? 4 : 2);
		if (!(mode == 7 && reg == 4))	/* ccr or sr is not dest */
			mode_reg (mode, reg, size);
	}
}

osize (inst, s)
int inst;
char *s;
{
	mode_reg ((inst >> 3) & 07, inst & 07, (*s == 'w') ? 2 : 4);
}

xsize (inst, s)
int inst;
char *s;
{
	int extension = instfetch (2);

	mode_reg ((inst >> 3) & 07, inst & 07, (*s == 'w') ? 2 : 4);
}

oneop (inst, opcode)
int inst;
{
	eff_addr (inst);
}

xoneop (inst, opcode)
int inst;
{
	int extension = instfetch (2);

	eff_addr (inst);
}

int fsize[] = { 4, 4, 12, 12, 2, 8, 1, 0};

foneop (inst, opcode)
int inst;
{
	int cmd = instfetch (2);
	int fmt;

	fmt = (cmd >> 10) & 07;
	switch ((cmd >> 13) & 07) {
	case 0:			/* fp data reg to fp data reg */
		break;
	case 1:			/* reserved encoding */
		break;
	case 2:			/* most fops */
		if (fmt == 7 && (inst & 0xCF) == 0) /* except fmovecr */
			break;
		else
			mode_reg ((inst >> 3) & 07, inst & 07, fsize[fmt]);
		break;
	case 3:			/* fmove from fp data regs */
		mode_reg ((inst >> 3) & 07, inst & 07, fsize[fmt]);
		break;
	case 4:			/* fmove(m) fp cntl regs from memory */
	case 5:			/* fmove(m) fp cntl regs to memory */
		eff_addr (inst);
		break;
	case 6:			/* fmovem fp data regs from memory */
	case 7:			/* fmovem fp data regs to memory */
		eff_addr (inst);
		break;
	}
}
