#include "errno.h"
#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"
#include "../wipc/wipc_pklink.h"

extern	splimp(), splx();
extern	sleep(), wakeup();
extern	timeout(), untimeout();

#define	PRIREC		26	/* priority to receive a message */
#define	PRIREP		5	/* priority to get a reply */

struct pklink **my_recq(), **my_repq();

/*
 * Find an unreceived packet on the current process' receive queue
 *  from the process specified by rpid (zero means from anybody).
 *  If there is no such packet, wait forever for one.  Mark the packet
 *  received so that we don't try to receive it again.
 */
struct sendpk *
FindNewReq(rpid)
register unsigned long rpid;
{
	register struct pklink *p, **pp = my_recq();
	extern unsigned long new_rmid();
	int s = splimp();
	struct sendpk *GetReq();

    tryagain:
	while (1) {
		for (p = *pp;  p;  p = p->next) {
			if (p->packet.type != T_SEND)
				continue;
			if (!VerifyPacket(p)) {
				SendNack(p, ENETRESET);
				p->packet.type = T_RECEIVED;
				if ((struct sendpk *)&p->packet !=
							GetReq(p->packet.src))
					panic("FindNewReq");
				ReleasePacket((struct sendpk *)&p->packet);
				goto tryagain;
			}
			if (rpid == 0  &&  MID(p->packet.src) == 0)
				p->packet.src |= new_rmid();
			if ((rpid == 0  ||  p->packet.src == rpid)) {
				p->packet.type = T_RECEIVED;
				splx(s);
				return (struct sendpk *)&p->packet;
			}
		}
		sleep(pp, PRIREC);
	}
}

/*
 * Search the reply queue for a packet from the specified process.
 *  Any other packets encountered are discarded.
 *  If an appropriate packet is not found, wait a while
 *  until timeout occurs.
 */
struct packet *
FindRep(sendseqid, tm)
unsigned short sendseqid;
int tm;
{
	register struct pklink *p, **pp = my_repq();
	int s = splimp();

	do {
/*
/*		while (p = *pp) {
/*			if (p->packet.sendseqid == sendseqid) {
/*				splx(s);
/*				return &p->packet;
/*			}
/*			*pp = p->next;
/*			ReleasePacket(&p->packet);  /* ignore unexpected crap */
/*		}
/* The above blows reentrancy (such as pageins)!  Replaced by the following. */
		for (p = *pp;  p;  p = p->next) {
			if (p->packet.sendseqid == sendseqid) {
				splx(s);
				return &p->packet;
			}
		}
/* End replacement.  We need to filter unexpected packets somewhere. */

		timeout(wakeup, pp, tm);
		sleep(pp, PRIREP);
		untimeout(wakeup, pp);
	} while (*pp);
	splx(s);
	return (struct packet *)0;
}

/*
 * Remove the specified packet from the reply queue, and free it.
 */
ReleaseRep(wp)
struct packet *wp;
{
	register struct pklink *p, *prev_p = (struct pklink *)my_repq();
	int s = splimp();

	for ( ;  p = prev_p->next;  prev_p = p) {
		if (&p->packet == wp) {
			prev_p->next = p->next;
			break;
		}
	}
	splx(s);
	ReleasePacket(wp);
}

/*
 * Find the packet from the indicated process on our receive queue.
 *  Remove it from the receive queue.
 *  Caller is responsible for actually freeing the packet.
 */
struct sendpk *
GetReq(rpid)
register unsigned long rpid;
{
	register struct pklink *p, *prev_p = (struct pklink *)my_recq();
	int s = splimp();

	for ( ;  p = prev_p->next;  prev_p = p) {
		if (p->packet.src == rpid  &&  p->packet.type == T_RECEIVED) {
			prev_p->next = p->next;
			break;
		}
	}
	splx(s);
	return p ? (struct sendpk *)&p->packet : (struct sendpk *)0;
}

/*
 * Find the packet from the indicated process on our receive queue.
 */
struct sendpk *
FindReq(rpid)
register unsigned long rpid;
{
	register struct pklink *p;
	int s = splimp();

	for (p = *my_recq();  p;  p = p->next)
		if (p->packet.src == rpid  &&  p->packet.type == T_RECEIVED)
			break;
	splx(s);
	return p ? (struct sendpk *)&p->packet : (struct sendpk *)0;
}

unsigned long
dataqck(wp)
register struct datapk *wp;
{
	register struct pklink *p = (struct pklink *)my_repq();
	register unsigned long rpid = wp->h.src, b = 0;

	while (p = p->next)
		if (p->packet.src == rpid  &&
		    p->packet.type == wp->h.type  &&
		    p->packet.sendseqid == wp->h.sendseqid  &&
		    p->packet.copyseqid == wp->h.copyseqid)
			b |= 1 << ((struct datapk *)(&p->packet))->frag.fragid;
	return b;
}

/*
 * CALLED AT INTERRUPT TIME
 *  ALSO FROM THE HIGH END FROM xForward()
 */
EnqueuePacket(p, recq, repq)
register struct pklink *p;
struct pklink **recq, **repq;
{
	register struct pklink *q;
	register int s;

	p->next = (struct pklink *)0;
	if (MAJVER(p->packet.version) != MAJVER(VERSION))
		return EPROTONOSUPPORT;
	switch (p->packet.type) {
	  case T_RECEIVED:			/* so forwarding works */
		p->packet.type = T_SEND;
		/* fall thru */
	  case T_SEND:
		if ((q = (struct pklink *)recq)->next == PKQCLOSED)
			return ECONNREFUSED;
		s = splimp();
		while (q->next) {
			q = q->next;
			if (q->packet.src == p->packet.src  &&
			    q->packet.sendseqid == p->packet.sendseqid) {
				if (q->packet.retry < p->packet.retry)
					q->packet.retry = p->packet.retry;
				splx(s);
				return EALREADY;
			}
		}
		q->next = p;
		splx(s);
		wakeup(recq);
		break;
	  case T_COPY_FROM_REQ:
		if ((q = (struct pklink *)repq)->next == PKQCLOSED)
			return ECONNREFUSED;
		s = splimp();
		while (q->next) {
			q = q->next;
			if (q->packet.src == p->packet.src  &&
			    q->packet.sendseqid == p->packet.sendseqid  &&
			    q->packet.copyseqid == p->packet.copyseqid) {
				splx(s);
				return EALREADY;
			}
		}
		q->next = p;
		splx(s);
		wakeup(repq);
		break;
	  case T_COPY_TO_REQ:
		if ((q = (struct pklink *)repq)->next == PKQCLOSED)
			return ECONNREFUSED;
		s = splimp();
		while (q->next) {
			q = q->next;
			if (q->packet.src == p->packet.src  &&
			    q->packet.sendseqid == p->packet.sendseqid  &&
			    q->packet.copyseqid == p->packet.copyseqid  &&
			    ((struct datapk *)(&q->packet))->frag.fragid ==
			    ((struct datapk *)(&p->packet))->frag.fragid) {
				splx(s);
				return EALREADY;
			}
		}
		q->next = p;
		splx(s);
		wakeup(repq);
		break;
	  case T_REPLY:
	  case T_COPY_FROM_REP:
	  case T_COPY_TO_REP:
	  case T_NACK:
		if ((q = (struct pklink *)repq)->next == PKQCLOSED)
			return ECONNREFUSED;
		s = splimp();
		switch (p->packet.type) {
		  case T_NACK:
			if ((char)p->packet.errcode < 0) {	/* KLUDGE */
				p->packet.errcode = -(char)p->packet.errcode;
				break;
			}
			/* else fall thru */
		  case T_COPY_FROM_REP:
		  case T_COPY_TO_REP:
			if ((q = (struct pklink *)recq)->next == PKQCLOSED)
				return ECONNREFUSED;
			while (q->next) {
				q = q->next;
				if (q->packet.src == p->packet.src  &&
				    q->packet.sendseqid ==
						    p->packet.sendseqid  &&
				    q->packet.copyseqid ==
						    p->packet.copyseqid)
					goto okrep;
			}
			splx(s);
			return EINVAL;
    okrep:
			q = (struct pklink *)repq;
		}
		while (q->next)
			q = q->next;
		q->next = p;
		splx(s);
		wakeup(repq);
		break;
	  default:
		return EINVAL;
	}
	return 0;
}

DequeuePackets(q)
struct pklink **q;
{
	register struct pklink *lp, *lp_prev;
	int s = splimp();

	lp = *q;
	*q = PKQCLOSED;
	if (lp != PKQCLOSED) {
		while (lp_prev = lp) {
			lp = lp_prev->next;
			lp_prev->next = (struct pklink *)0;
			ReleasePacket(&lp_prev->packet);
		}
	}
	splx(s);
}

EnableRecQueue()
{
	return EnableQueue(my_recq());
}

EnableRepQueue()
{
	return EnableQueue(my_repq());
}

EnableQueue(p)
struct pklink **p;
{
	if (*p == PKQCLOSED) {
		*p = (struct pklink *)0;
		return 0;
	}
	return 1;
}

DisableRecQueue()
{
	DisableQueue(my_recq());
}

DisableRepQueue()
{
	DisableQueue(my_repq());
}

DisableQueue(p)
struct pklink **p;
{
	int s = splimp();

	DequeuePackets(p);
	*p = PKQCLOSED;
	splx(s);
}

/*
 * Flush any packets remaining on reply queue
 *  associated with rpid, sendseqid.
 */
FlushRepQueue(rpid, sendseqid)
register unsigned long rpid;
unsigned short sendseqid;
{
	register struct pklink *p, *prev_p = (struct pklink *)my_repq();

	if (prev_p->next  &&  prev_p->next != PKQCLOSED  &&
	    MID(rpid)  &&  MID(rpid) != BROADCAST_MID) {
		int s = splimp();
		while (p = prev_p->next) {
			if (rpid == p->packet.src  &&
			    sendseqid == p->packet.sendseqid) {
				prev_p->next = p->next;
				ReleasePacket(&p->packet);
			} else
				prev_p = p;
		}
		splx(s);
	}
}

