#include "../h/errno.h"

#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"
#include "../wipc/wipc_pklink.h"
#include "../is68kif/if_pkbuf.h"

#define	PKLEN	(PKBUFSIZE - 48)
#define	PKBURST	6

int wloop_xmit(), wloop_relse();
int wloop_ix;

wloop_attach()
{
	long zero = 0;

	wloop_ix = IfaceAttach(0, wloop_xmit, wloop_relse,
			PKLEN, PKBURST, (char *)0, sizeof(long));
	IfaceUp(wloop_ix);
	MinfoAttach(wloop_ix, &zero, "loopback", SELF_MID, SELF_MID, 0, 0);
}

wloop_xmit(unit, naddr, p, len, fp0, fp1)
	char *naddr;
	struct packet *p;
	unsigned long len;
	struct fragment *fp0, *fp1;
{
	register struct pkbuf *pkb;
	register struct pklink *lp;
	int n, s;

	if ((pkb = GetPkBuf()) == (struct pkbuf *)0)
		return EBUSY;
	lp = (struct pklink *)pkb->pkb_buffer;
	pkbuild(&lp->packet, p, len, fp0, fp1);
	bzero(lp->netaddr, sizeof lp->netaddr);
	lp->buflen = PKBUFSIZE;
	lp->prelen = 0;
	lp->ix = wloop_ix;
	lp->handle = (int)pkb;
	if (n = ReceivePacket(lp))
		wloop_relse(unit, lp);
	return n;
}

wloop_relse(unit, lp)
	struct pklink *lp;
{
	FreePkBuf((struct pkbuf *)lp->handle);
}
