/* Handle encapulation of trfs packets within IP packets */

#include "param.h"
#include "mbuf.h"
#include "errno.h"
#include "socket.h"
#include "socketvar.h"

#include "../net/if.h"
#include "../net/route.h"

#include "../netinet/in.h"
#include "../netinet/in_systm.h"
#include "../netinet/ip.h"
#include "../netinet/ip_var.h"
#include "../netinet/if_ether.h"

#include "../is68kif/if_pkbuf.h"
#include "../is68kif/if_qb.h"

#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"
#include "../wipc/wipc_pklink.h"

#define	PKLEN		(ETHERMTU - 48 - 4)
#define	PKBURST		6

int wipc_ip_xmit(), wipc_ip_relse();
int wipc_ip_ix = -1;

wipc_ip_init()
{
	wipc_ip_ix = IfaceAttach(0, wipc_ip_xmit, wipc_ip_relse,
			PKLEN, PKBURST, (char *)0, sizeof(struct in_addr));
	IfaceUp(wipc_ip_ix);
}

wipc_ip_xmit(unit, naddr, p, len, fp0, fp1)
	struct in_addr *naddr;
	struct packet *p;
	unsigned long len;
	struct fragment *fp0, *fp1;
{
	register struct mbuf *m;
	register struct ip *ip;

	if ((m = m_get(M_DONTWAIT, MT_HEADER)) == (struct mbuf *)0)
		return ENOBUFS;
	m->m_len = sizeof(struct pklink) - sizeof(struct packet);
	m->m_off = MMAXOFF - m->m_len;
	if ((len = pkbuild_mbuf(m, p, len, fp0, fp1)) == 0)
		return ENOBUFS;
	ip = mtod(m, struct ip *);
	ip->ip_off = 0;
	ip->ip_p = IPPROTO_WIPC;
	ip->ip_len = sizeof(struct pklink) - sizeof(struct packet) + len;
	ip->ip_src.s_addr = INADDR_ANY;		/* ip_output will fill in */
	ip->ip_dst = *naddr;
	ip->ip_ttl = MAXTTL;
	return ip_output(m, (struct mbuf *)0, (struct route *)0, 0);
}

pkbuild_mbuf(m, sp, len, fp0, fp1)
	register struct mbuf *m;
	struct packet *sp;
	register unsigned long len;
	register struct fragment *fp0, *fp1;
{
	register struct pkbuf *pkb;
	register char *p;

	if ((pkb = GetPkBuf()) == (struct pkbuf *)0)
		return 0;
	p = pkb->pkb_buffer;
	if ((len = pkbuild(p, sp, len, fp0, fp1)) == 0  ||
	    (m->m_next = if_rqbget(p, len, 0, 0, 0)) == (struct mbuf *)0) {
		m_freem(m);
		len = 0;
	}
	FreePkBuf(pkb);
	return len;
}

wipc_ip_input(m, ifp)
	struct mbuf *m;
	struct ifnet *ifp;
{
	register struct pkbuf *pkb;
	register struct pklink *p;

	if ((pkb = GetPkBuf()) == (struct pkbuf *)0) {
		m_freem(m);
		return;
	}
	p = (struct pklink *)pkb->pkb_buffer;
	if_wqbput((char *)p, m);
	ovbcopy((char *)&((struct ip *)p)->ip_src, p->netaddr,
						sizeof(struct in_addr));
	p->buflen = ETHERMTU;
	p->prelen = 0;
	p->ix = wipc_ip_ix;
	p->handle = (int)pkb;
	if (ReceivePacket(p))
		FreePkBuf(pkb);
}

wipc_ip_relse(unit, p)
	struct pklink *p;
{
	FreePkBuf((struct pkbuf *)p->handle);
}
