#include "errno.h"
#include "param.h"
#include "types.h"
#include "time.h"
#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"
#include "../wipc/wipc_pklink.h"
#include "../trfs/trfs.h"

unsigned long
Connect(name, rmid)
	char *name;
	unsigned long rmid;
{
	struct msg_connect msg;
	extern unsigned long MinfoAttach();
	extern char hostname[];

	bzero(&msg, sizeof msg);
	msg.h.rcode = RQ_CONNECT;
	msg.rmid = 0;
	strncpy(msg.mname, name, sizeof msg.mname - 2);
	if (xSend(&msg, rmid | INTERRUPT_PID) == 0)
		return 0;
	rmid = MinfoAttach(msg.ix, msg.naddr, msg.mname, new_rmid(), 0, 0, 0);
	msg.rmid = rmid;
	msg.pklen = MaxPktLen(rmid);
	msg.pkburst = MaxPktBurst(rmid);
	MinfoAttach(msg.ix, msg.naddr, name, 0, 0, 0, 0);
	bzero(msg.mname, sizeof msg.mname);
	strncpy(msg.mname, hostname, sizeof msg.mname - 2);
	if (xSend(&msg, rmid | SERVER_PID) == 0) {
		MinfoDetach((char *)0, rmid);
		return 0;
	}
	SetNetTime(msg.sec, msg.usec);
	return MinfoAttach(msg.ix, msg.naddr, msg.mname, 0, msg.rmid,
						msg.pklen, msg.pkburst);
}

Disconnect(rpid)
	unsigned long rpid;
{
	struct msg_connect msg;
	extern char hostname[];

	bzero(&msg, sizeof msg);
	msg.h.rcode = RQ_DISCONNECT;
	strncpy(msg.mname, hostname, sizeof msg.mname - 2);
	if ((rpid = MID(rpid))  &&  rpid != BROADCAST_MID) {
		if (xSend(&msg, rpid | SERVER_PID)) {
			MinfoDetach(msg.mname, rpid);
			return 1;
		}
		return 0;
	}
	msg.h.rflags |= RF_NOREP;
	xSend(&msg, BROADCAST_MID | SERVER_PID);
	return 1;
}

/*
 * CALLED AT INTERRUPT TIME!
 */
InterruptReceive(lp)
	register struct pklink *lp;
{
	register struct msg_connect *mp;

	if (lp->packet.type == T_SEND  ||  lp->packet.type == T_REPLY) {
		mp = (struct msg_connect *)
					&((struct sendpk *)(&lp->packet))->msg;
		if ((mp->h.rcode == RQ_CONNECT  ||
		     mp->h.rcode == RQ_DISCONNECT)  &&
		    (mp->h.rflags & RF_USER) == 0) {
			bcopy(lp->netaddr, mp->naddr, sizeof mp->naddr);
			mp->ix = lp->ix;
			if (lp->packet.type == T_SEND  &&
			    PID(lp->packet.dst) == INTERRUPT_PID) {
				if (iamhere(mp))
					SendRep(lp);
				return 1;
			}
		}
	}
	return PID(lp->packet.dst) == INTERRUPT_PID;
}

/*
 * CALLED AT INTERRUPT TIME!
 */
iamhere(mp)
	struct msg_connect *mp;
{
	extern char hostname[];
	register char *name = mp->mname;
	register char *names = hostname;

	while (*names)
		if (strcmp(name, names) == 0) {
			bzero(mp->mname, sizeof mp->mname);
			strncpy(mp->mname, hostname, sizeof mp->mname - 2);
			return 1;
		} else while (*names++)
			;
	return 0;
}

GotConnect(mp, rpid)
	register struct msg_connect *mp;
	unsigned long rpid;
{
	unsigned short pklen;
	unsigned char pkburst;
	extern unsigned long MinfoAttach();
	extern char hostname[];
	extern struct timeval time;

	if (mp->mname[0] == '\0') {
		xReply((struct wmsg *)0, rpid);	/* ignore anonymous connects */
		return;
	}
	mp->rmid = MinfoAttach(mp->ix, mp->naddr, mp->mname,
						MID(rpid), mp->rmid, 0, 0);
	pklen = mp->pklen;
	pkburst = mp->pkburst;
	mp->pklen = MaxPktLen(mp->rmid);
	mp->pkburst = MaxPktBurst(mp->rmid);
	if (pkburst == 0) {		/* BACKWARDS COMPATABILITY */
		pklen = mp->pklen;	/* BACKWARDS COMPATABILITY */
		pkburst = mp->pkburst;	/* BACKWARDS COMPATABILITY */
	}				/* BACKWARDS COMPATABILITY */
	MinfoAttach(mp->ix, mp->naddr, mp->mname, 0, 0, pklen, pkburst);
	bzero(mp->mname, sizeof mp->mname);
	strncpy(mp->mname, hostname, sizeof mp->mname - 2);
	mp->sec = time.tv_sec;
	mp->usec = time.tv_usec;
}

GotDisconnect(mp, rpid)
	register struct msg_connect *mp;
	unsigned long rpid;
{
	extern char hostname[];
	char mname[32];

	strncpy(mname, mp->mname, sizeof mname - 2);
	if ((mp->h.rflags & RF_NOREP) == 0) {
		bzero(mp->mname, sizeof mp->mname);
		strncpy(mp->mname, hostname, sizeof mp->mname - 2);
		xReply(mp, rpid);
	}
	MinfoDetach(mname, MID(rpid));
	ServerDisconnect(mname);
}
