#include "../h/ucode.h"
/******************************************************************************
* boxc
*
* Copies rectangular region with upper left corner at (Xs,Ys) to a
*	rectangular region with upper left corner at (Xd,Yd).
*	These cooridinates are relative to the source and destination
*	raster addresses. Width and height applies to both rectangles.
*
* Assembly Interface:
*	input:
*		d0 = Xs
*		d1 = Ys
*		d2 = width
*		d3 = height
*		d4 = Xd
*		d5 = Yd
*		a2 = source raster address
*		a3 = destination raster address
*	output:
*		all registers saved
*
******************************************************************************/
	.text
	.globl	boxc
boxc:	movl	d6,sp@-			/* save register */
	movl	#GP_BOXC,d6		/* box copy command */
	jsr	cmd_sdrast		/* do raster command */
	movl	sp@+,d6			/* restore register */
	rts
