/******************************************************************************
* alu_mode
*
* Sets the alu mode
* 	currently only CLEAR, SET and TOGGLE
*
* Assembly Interface:
*	input:
*		d0 = mode command
*	output:
*		all registers are saved
*
******************************************************************************/
	.data
UCalumode:
	.word	0			/* save last mode command */

	.text
	.globl	alu_mode
alu_mode:
	cmpw	UCalumode,d0		/* check for already set */
	beq	1f			/* skip load if so */
	movw	d0,UCalumode		/* set memory copy */
	movl	d0,sp@-			/* command */
	movl	#1,sp@-			/* number of paramters */
	jsr	_UCoutput		/* execute */
	addl	#(2*4),sp		/* clear stack */
    1:	rts
