/******************************************************************************
* Overlap(r1, r2)
*
* Returns true if and only if rectangles "r1" and "r2"  overlap
*
* C Interface:
*
*	bool Within(r1, r2)
*	struct rectangle r1, r2;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| r1.x           | r1.y           |  0 (W), 2 (W)
*	+---------------------------------+
*	| r1.w           | r1.h           |  4 (W), 6 (W)
*	+---------------------------------+
*	| r2.x           | r2.y           |  8 (W), 10 (W)
*	+---------------------------------+
*	| r2.w           | r2.h           | 12 (W), 14 (W)
*	+---------------------------------+
*
******************************************************************************/
r1x	= 0+8
r1y	= 2+8
r1w	= 4+8
r1h	= 6+8
r2x	= 8+8
r2y	= 10+8
r2w	= 12+8
r2h	= 14+8

	.text
	.globl	_Overlap
_Overlap:
	link	a6,#0			/* establish stack frame */

	movw	a6@(r1x),d0		/* get left edge of first rectangle */
	subw	a6@(r2x),d0		/* distance from second to first */
	bge	1f			/* branch if second is leftmost */

	addw	a6@(r1w),d0		/* check against right edge */
	ble	4f			/* return false if second beyond first */
	bra	2f			/* check vertical direction */

    1:	subw	a6@(r2w),d0		/* check against right edge */
	bge	4f			/* return false if first beyond second */

    2:	movw	a6@(r1y),d0		/* get top edge of first rectangle */
	subw	a6@(r2y),d0		/* distance from second to first */
	bge	3f			/* branch if second is topmost */

	addw	a6@(r1h),d0		/* check against bottom edge */
	ble	4f			/* return false if second beyond first */
	bra	5f			/* otherwise return true */

    3:	subw	a6@(r2h),d0		/* check against bottom edge */
	bge	4f			/* return false if first beyond second */

    5:	moveq	#1,d0			/* get value for true */
	unlk	a6			/* remove stack frame */
	rts				/* return it */
	
    4:	clrl	d0			/* get value for false */
	unlk	a6			/* remove stack frame */
	rts				/* return it */
