/******************************************************************************
* Left(result, r, y)
*
* Splits rectangle "r" horizontally at coordinate "x" and returns a rectangle
* that includes the split and everything to its left.
*
* C Interface:
*
*	Left(result, r, x)
*	struct rectangle *result, r;
*	word x;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| answer			  |  0 (L)
*	+---------------------------------+
*	| r.x            | r.y            |  4 (W), 6 (W)
*	+---------------------------------+
*	| r.w            | r.h            |  8 (W), 10 (W)
*	+---------------------------------+
*	| ///////////////| x              |  14 (W)
*	+---------------------------------+
*
******************************************************************************/
ans	= 0+8
rx	= 4+8
ry	= 6+8
rw	= 8+8
rh	= 10+8
x	= 14+8

	.text
	.globl	_Left
_Left:	link	a6,#0			/* set up stack frame */
	moveml	#<d2-d3>,sp@-		/* save registers */
	movemw	a6@(rx),#<d0-d3>	/* blast rectangle in */

	movw	a6@(x),d2		/* get dividing X coordinate */
	subw	d0,d2			/* subtract rectangle left side */
	addqw	#1,d2			/* include split in result */

	movl	a6@(ans),a0		/* get address of result */
	movemw	#<d0-d3>,a0@		/* blast result out */
	moveml	sp@+,#<d2-d3>		/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
