#include "../h/ucode.h"
/******************************************************************************
* PaintRaster(mask, mx, my, raster, rx, ry, w, h, color)
*
* Paints the rectangle of width "w" and height "h" located at ("rx", "ry") in
* "raster".  The rectangle is painted with "color" whereever there is a 1 bit
* in the rectangle of the same size at ("mx", "my") in "mask".
*
* C Interface:
*
*	PaintRaster(mask, mx, my, raster, rx, ry, w, h, color)
*	RASTER *mask, *raster;
*	int mx, my, rx, ry, w, h;
*	COLOR color;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| mask                            |  0 (L)
*	+---------------------------------+
*	|////////////////| mx             |  6 (W)
*	+---------------------------------+
*	|////////////////| my             | 10 (W)
*	+---------------------------------+
*	| raster                          | 12 (L)
*	+---------------------------------+
*	|////////////////| rx             | 18 (W)
*	+---------------------------------+
*	|////////////////| ry             | 22 (W)
*	+---------------------------------+
*	|////////////////| w              | 26 (W)
*	+---------------------------------+
*	|////////////////| h              | 30 (W)
*	+---------------------------------+
*	|////////////////| color          | 34 (W)
*	+---------------------------------+
*
******************************************************************************/
	.text
	.globl	_PaintRaster
_PaintRaster:
	link	a6,#0			/* establish frame pointer */
	moveml	#<d2-d7,a2-a5>,sp@-	/* save registers */
#ifdef UCODE_PAINT
#ifdef UCODE_ALU
#ifdef UCODE_PITCH
	/* See if within display memory */
	movl	a6@(0+8),a0		/* get mask raster pointer */
	movl	a0@(2),a2		/* get raster address */
	movw	a0@,a0			/* get raster width */
	movl	a6@(12+8),a1		/* get destination raster pointer */
	movl	a1@(2),a3		/* get raster address */
	movw	a1@,a1			/* get raster width */
	jsr	dispchk			/* check */
	bne	manual			/* no do it the hard way */

	/* Clear according to specified color */
	btst	#GPCOLOR_B,_gptype	/* is this a color system */
	jeq	1f
	movw	a6@(34+8),d0		/* get color */
	jsr	set_color
	jra	2f

    1:	movw	a6@(34+8),d7		/* get color */
	tstw	d7			/* test color */
	bne	gwhite			/* branch if white */
gblack:	movw	#GP_ALUC,d0		/* alu clear command */
	bra	1f			/* go set */
gwhite:	movw	#GP_ALUS,d0		/* alu set command */
    1:	jsr	alu_mode		/* alu mode set */

	/* Set the source and destination pitch */
    2:	jsr	set_pitch

	/* Get parameters and normalize rectangles */
	movw	a6@(18+8),d0		/* get destination X coordinate */
	movw	a6@(22+8),d1		/* get destination Y coordinate */
	movw	a6@(26+8),d2		/* get width */
	movw	a6@(30+8),d3		/* get height */
	jsr	Adjust			/* adjust to positive */
	movw	d0,d4			/* save normalized dest X */
	movw	d1,d5			/* save normalized dest Y */

	movw	a6@(6+8),d0		/* get source X coordinate */
	movw	a6@(10+8),d1		/* get source Y coordinate */
	movw	a6@(26+8),d2		/* get width */
	movw	a6@(30+8),d3		/* get height */
	jsr	Adjust			/* adjust to positive */

	/* Paint rectangle */ 
	jsr	paint			/* do paint */
	bra	return			/* return */
#endif UCODE_PITCH
#endif UCODE_ALU
#endif UCODE_PAINT

	/* Get C parameters */
manual:	movl	a6@(0+8),a0		/* get mask pointer */
	movl	a0@(2),a2		/* get mask address */
	movw	a0@,a0			/* get mask width */
	movw	a6@(6+8),d0		/* get mask X coordinate */
	movw	a6@(10+8),d1		/* get mask Y coordinate */
	movl	a6@(12+8),a1		/* get raster pointer */
	movl	a1@(2),a3		/* get raster address */
	movw	a1@,a1			/* get raster width */
	movw	a6@(18+8),d2		/* get raster X coordinate */
	movw	a6@(22+8),d3		/* get raster Y coordinate */
	movw	a6@(26+8),d4		/* get width */
	movw	a6@(30+8),d5		/* get height */
	movw	a6@(34+8),d7		/* get color */

	/* Setup registers */
	jsr	setup			/* do the setup */
	blt	return			/* return if nothing to do */
	andw	#0xf,d1			/* adjust rotation */
#ifdef UCODE
	jsr	_CPUgetdisp		/* get display */
#endif UCODE

	/* Paint according to color and direction */
	tstw	d7			/* test color */
	beqs	black			/* branch if black */
white:	cmpl	#0,a4			/* test increment direction for white */
	bgts	whinc			/* branch if incrementing */
	bras	whdec			/* branch if decrementing */

black:	notw	d2			/* complement initial mask */
	notw	d3			/* complement final mask */
	cmpl	#0,a4			/* test increment direction for black */
	bgts	blinc			/* branch if incrementing */
	bra	bldec			/* branch if decrementing */

	/* Paint with white, incrementing addresses */
whinc:
    1:	movl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	andw	d2,d6			/* keep valid bits */
	orw	d6,a3@+			/* write destination back */
	addql	#2,a2			/* bump source address */
	movw	d4,d0			/* initialize word counter */
	blts	3f			/* skip loop if zero */

    2:	movl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	orw	d6,a3@+			/* write it out */
	addql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	movl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	andw	d3,d6			/* keep valid bits */
	orw	d6,a3@			/* write destination back */
	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

	/* Paint with white, decrementing addresses */
whdec:
    1:	movl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	andw	d2,d6			/* keep valid bits */
	orw	d6,a3@			/* write destination back */
	subql	#2,a2			/* bump source address */
	movw	d4,d0			/* initialize word counter */
	blts	3f			/* skip loop if zero */

    2:	movl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	orw	d6,a3@-			/* write it out */
	subql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	movl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	andw	d3,d6			/* keep valid bits */
	orw	d6,a3@-			/* write destination back */
	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

	/* Paint with black, incrementing addresses */
blinc:
    1:	movl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	orw	d2,d6			/* make invalid bits harmless */
	andw	d6,a3@+			/* combine source with destination */
	addql	#2,a2			/* bump source address */
	movw	d4,d0			/* initialize word counter */
	blts	3f			/* skip loop if zero */

    2:	movl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	andw	d6,a3@+			/* combine source with destination */
	addql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	movl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	orw	d3,d6			/* make invalid bits harmless */
	andw	d6,a3@			/* combine source with destination */
	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

	/* Paint with black, decrementing addresses */
bldec:
    1:	movl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	orw	d2,d6			/* make invalid bits harmless */
	andw	d6,a3@			/* combine source with destination */
	subql	#2,a2			/* bump source address */
	movw	d4,d0			/* initialize word counter */
	blts	3f			/* skip loop if zero */

    2:	movl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	andw	d6,a3@-			/* combine source with destination */
	subql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	movl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	orw	d3,d6			/* make invalid bits harmless */
	andw	d6,a3@-			/* combine source with destination */
	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

returnd:	
#ifdef UCODE_DEBUG
	jsr	_CPUrlsdisp		/* release display */
#endif UCODE_DEBUG
return:	moveml	sp@+,#<d2-d7,a2-a5>	/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
