#include "../h/ucode.h"
/***************************************************************************
* dispchk
*
* Check addresses for inclusion within display memory
*
* Assembly interface:
*	input:
*		a2 = source raster pointer (0 if no source)
*
*		a3 = destination raster pointer
*	output:
*		all registers are saved
*		Z bit set if all within display memory
*
**************************************************************************/
	.text
	.globl	dispchk
dispchk:
	btst	#GPHASGIP_B,_gptype	/* check if we should be using gip */
	beq	2f
	cmpl	_screen+2,a3		/* is dst >= display memory? */
	blt	2f			/* no outside */
	cmpl	_screen+6,a3		/* is dst < display memory? */
	bge	2f			/* no outside */
	cmpl	#0,a2			/* check if source address */
	beq	1f			/* no source, we are in */
	cmpl	_screen+2,a2		/* is src >= display memory */
	blt	2f			/* no outside */
	cmpl	_screen+6,a2		/* is src < display memory */
	bge	2f			/* no outside */
    1:	orb	#0x4,cc			/* set Z bit */
	rts				/* return */
    2:	andb	#0x1B,cc		/* reset Z bit */
	rts				/* return */
