/*
 *	This file defines the structures needed for tile manipulation
 */

#ifndef _TILE
#define _TILE
/*
 *	A tile is rectangular regions which is either fully hidden or
 *	exposed at any given time.  A tile also has forword (points to) and
 *	backwards (points from) links to other tiles so that they may be
 *	dealt with in doubly linked lists.
 */
struct tile
{
	struct tile		*prev;		/* links to other tiles */
	struct tile		*next;
	bool			hidden;		/* state of tile */
	struct rectangle	bounds;		/* clipping bounds of tile */
};

#endif
