#include "../h/ucode.h"
/******************************************************************************
* CopyArea(sx, sy, dx, dy, w, h)
*
* Copies the rectangular area of width "w" and height "h" from location
* ("sx", "sy") of the screen to location ("dx", "dy").  The copy is done in
* such a way that if source and destination overlap, no information is lost.
* This routine does NOT do clipping.
*
* C Interface:
*
*	CopyArea(sx, sy, dx, dy, w, h)
*	int sx, sy, dx, dy, w, h;
*
* Assembly Interface:
*
*	+---------------------------------+
*	|////////////////| sx             |  2 (W)
*	+---------------------------------+
*	|////////////////| sy             |  6 (W)
*	+---------------------------------+
*	|////////////////| dx             | 10 (W)
*	+---------------------------------+
*	|////////////////| dy             | 14 (W)
*	+---------------------------------+
*	|////////////////| w              | 18 (W)
*	+---------------------------------+
*	|////////////////| h              | 22 (W)
*	+---------------------------------+
*
******************************************************************************/
	.set	sx,	2
	.set	sy,	6
	.set	dx,	10
	.set	dy,	14
	.set	w,	18
	.set	h,	22

	.text
	.globl	_CopyArea
_CopyArea:
	link	a6,#0			/* establish stack frame */
	moveml	#<d2-d5>,sp@-		/* save working registers */

	/* Get destination rectangle and clip */
	movw	a6@(dx+8),d0		/* get destination X */
	movw	a6@(dy+8),d1		/* get destination Y */
	movw	a6@(w+8),d2		/* get width */
	movw	a6@(h+8),d3		/* get height */
	movw	d0,d4			/* remember unclipped X */
	movw	d1,d5			/* remember unclipped Y */

	jsr	RClip			/* clip destination rectangle */
	ble	1f			/* return if nothing visible */

	/* Pass destination parameters to CopyRaster */
	movl	d3,sp@-			/* pass height */
	movl	d2,sp@-			/* pass width */
	movl	d1,sp@-			/* pass Y coordinate */
	movl	d0,sp@-			/* pass X coordinate */
	movl	#_screen,sp@-		/* pass screen raster descriptor */

	/* Adjust source rectangle to clipped destination */
	subw	d4,d0			/* compute X clip offset */
	addw	a6@(sx+8),d0		/* add in source X */
	subw	d5,d1			/* compute Y clip offset */
	addw	a6@(sy+8),d1		/* add in source Y */
	
	/* Pass source parameters to CopyRaster */
	movl	d1,sp@-			/* pass source Y */
	movl	d0,sp@-			/* pass source X */
	movl	#_screen,sp@-		/* pass screen raster descriptor */

	/* Perform the copy */
	jsr	_CopyRaster		/* copy the area */
	addl	#32,sp			/* clean parameters off stack */

    1:	moveml	sp@+,#<d2-d5>		/* restore working registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
