/* 
 * structures and defines needed for virtual terminal output calls 
 */

#ifndef _VT_OUTPUT
#define _VT_OUTPUT

#ifdef KERNEL
#include "../machine/defs.h"
#include "ioctl.h"			/* get macro definition */
#else
#include <machine/defs.h>
#include <sys/ioctl.h>			/* get macro definition */
#endif

/*
 * struct for user agent to use when getting size/position for a window 
 */
struct uwindow {
	short win;
	short val1;
	short val2;
};

/*
 * struct and defines used with user rasterops
 */
struct rasterop {
        unsigned char type;	    	/* type of RasterOp */
	short		*ras;		/* pointer to the raster */
	short		width;		/* raster width (in even # of bytes) */
	short		sx, sy;		/* source position */
	short	        x, y;	    	/* destination position */
	short		w, h;	    	/* size */
	short		color;		/* color (needed only for PAINT) */
};
#define COPYRASTER	0
#define TOGGLERASTER	1
#define PAINTRASTER	2

/*
/*
 * struct and defines used to play with clipping bounds 
 */
struct clipbnd {
        unsigned char type;	    /* type of bounds */
	short	         x;	    /* x start */
	short		 y;	    /* y start */
	short		 w;	    /* width */
	short		 h;	    /* height */
};
#define	SetPerm	    0		/* type to set permanant bounds */
#define ResPerm	    1		/* Restrict permanant */
#define SetTemp	    2		/* set temporary bounds */
#define	ResTemp	    3		/* restrict temporary */
#define	GetPerm	    4		/* get permanent bounds */
#define	GetTemp	    5		/* get temporary bounds */
#define GetRefr     7		/* get refresh bounds */
#define BabyBox     6		/* move rubber baby band boxes, ua only */

/*
 * struct used to define a cursor
 */
struct curpat {
	unsigned char type;	/* type of cursor */
	int	      *mask;    /* mask and face of cursor */
	int	      *face;
	short	      xref;	/* x referance point */
	short	      yref;
	short	      blink;	/* bilnk rate */
};
#define LocalCur    0		/* define locall cursor */
#define GlobalCur   1		/* define global cursor */

/*
 *	struct used to track the cursor
 */
struct trackmouse {
	short	type;		
	short	x, y, w, h;	/* size/position of box */
	short	bx, by, bw, bh;	/* box bounds */
	short	thickness;
};
#define TrackFixed	1
#define TrackRubber	2

/*
 * struct used to define an icon
 */
struct iconpat {
	int	      *mask;    /* mask and face of icon */
	int	      *face;
	short	      width, height;
	short	      index;	/* index of defined icon */
};

/*
 * struct used to enquire about character attricbutues 
 */
struct charatt {
	unsigned char	type;	/* type of call */
	unsigned short	font;	/* ID of font */
	short		val;	/* width, height or baseline on output or
				 * char on Cwidth input */
};
#define Cheight	    0		/* get character height */
#define Cbaseline   1		/* get character baseline */
#define Cwidth	    2		/* get character width */
#define Ctype	    3		/* get character type */

/*
 *	Structures to be used when getting/setting the configuration
 */
struct mconfig {	/* mouse configuration */
	unsigned char mc_delta;
	unsigned char mc_table[VT_MTABSIZE+1];
};

struct gconfig {	/* graphics hardware config */
	short	w, h;
	short	x_res, y_res;
	int	lutsize;
	int	nred, ngreen, nblue;
	short	nwindows;
	short	nistyles;
	short	nicons;
	int	realcolors;
};

/* 	
 *	structure definitions for ioctls that deal with the color lookup table
 */

struct colorlut {
	int	color;
	int	red;
	int	green;
	int	blue;
	int	type;
};
#define  VT_FREE	0
#define  VT_SHARE	1
#define  VT_OWN		(-1)

/*
 *	The following is the structure used to get the current window state.
 *	This will be used by any packages which sit on top of an application
 *	to allow for the restoration of the window state before exit.
 */
struct wstate {
	short	fcolor, bcolor; /* current color index */
	unsigned short	font;	/* current font ID */
	short	xpos,ypos;	/* current position */
	short	addressing;	/* current addressing mode */
	short	justification;	/* string justification */
	short	orientation;	/* string orientation */
	short	direction;	/* string direction */
	short	ctype;		/* character attributes */
	short	xphase, yphase; /* phase of patterns */
	short	thickness;	/* line thickness */
	short	count, mask;	/* line style mask and count */
	short	width, height;	/* window size */
	short   px, py, pw, ph; /* permanant clipping bounds */
	short   tx, ty, tw, th; /* temporary clipping bounds */
	short   mmode;		/* current operating flags for vt */
	int	ldisc;		/* current line discipline */
	short	cvisible;	/* current visibility of local cursor */
};

/*
 * the following names are used when makeing an ioctl call to change the
 * local virtual terminal enviroment.  Names starting with TIOV can be
 * used by all vts for their local settings.  Names starting with TIOU
 * can only be used by the process that has the desktop open.
*/

#define	TIOVSETMM	_IOW(v, 13, short)	     /* set mouse mode */

#define TIOVSETC	_IOW(v, 24, struct clipbnd)  /* set clipping bounds */
#define TIOVGETC	_IOWR(v, 28, struct clipbnd) /* get clipping bounds */
#define	TIOVSETEF	_IOW(v, 29, short)	     /* set emulator font */
#define TIOVPOPQ	_IOWR(v,30,char[127])	     /* display a pop-up menu */
#define TIOVDEFC	_IOW(v, 31, struct curpat)   /* define a cursor */
#define TIOVTRCKM	_IOWR(v, 32, struct trackmouse) /* track the mouse */
#define TIOVGCHR	_IOWR(v, 33, struct charatt) /* get char attribute */
#define	TIOVSETE	_IOW(v, 34, char)	     /* set terminal emulator */
#define TIOVLED		_IOW(v, 35, char[6])  	     /* def leds for this vt */
#define TIOVSETSK	_IOW(v, 36, struct def_sfk)  /* def 1 soft key name */
#define TIOVSETT	_IOW(v, 39, char[VT_MAXTITLE])/* set window title */
#define TIOVSETPC	_IOW(v, 40, short[3])	     /* set pane color */
#define TIOVGLLUT	_IOWR(v, 41, struct colorlut)/* get local LUT */
#define TIOVSLLUT	_IOW(v, 42, struct colorlut) /* set local LUT */
#define TIOVGETMP	_IOR(v, 45, short[2])	     /* Get mouse position */
#define TIOVGETHW	_IOR(v, 46, struct gconfig)  /* Get HW config */
#define TIOVMYGIP	_IOW(v, 47, short)	     /* control GIP ownership */
#define TIOVGSTATE	_IOR(v,52,struct wstate)     /* get window state */
#define TIOVRASTOP	_IOW(v,53,struct rasterop)   /* do a user rasterop */

/* protected ioctl calls for use by user agent only */

#define	TIOUNEWVT	_IOW(u, 11, short)	/* set new active vt */
#define	TIOUSETCP	_IOW(u, 12, short[4])	/* set console open position */
#define	TIOUGETWS	_IOWR(u, 13, short[3])	/* get named window size */
#define TIOUSETWS	_IOW(u, 14, short[3])	/* set named window size */
#define	TIOUGETWP	_IOWR(u, 15, short[3])	/* get named window position*/
#define TIOUSETWP	_IOW(u, 16, short[3])	/* set named window position*/
#define	TIOUGETWD	_IOWR(u, 17, short[2])	/* get named window depth */
#define TIOUSETWD	_IOW(u, 18, short[2])	/* set named window depth */
#define TIOUGETWN	_IOR(u, 19, short)	/* get number of window */
#define TIOUSETPC	_IOW(u, 20, short[4])	/* set win pane color */
#define TIOUDEFI	_IOW(u, 21, struct iconpat)  /* define icon */
#define TIOUMVBOX	_IOW(u, 22, struct clipbnd) /* move baby band boxes*/
#define TIOUNOBOX       _IO(u, 23)              /* off rubber baby bands */
#define TIOUSICON	_IOWR(u, 24, short[22])	/* put icon on desktop   */
#define TIOUIICON	_IOW(u,25,short)	/* invert icon */
#define TIOUDICON	_IOW(u,26,short)	/* delete icon */
#define TIOUSSTAT	_IOW(u,27,char[127])	/* display status line */
#define TIOUDSTAT	_IO(u,28)		/* delete status line */
#define TIOUSCLUT	_IOW(u,29,struct colorlut)	/* load color LUT */
#define	TIOUWPGRP	_IOWR(u, 30, short[2])	/* get named window pgrp */
#define TIOUSETWF	_IOW(u, 31, short[2])	/* set named window font */
#define	TIOUTOPW	_IOR(u, 32, short)	/* get name of top window */
#define TIOUMBND	_IOW(u,40,short[4])	/* set mouse clip bounds */
#define TIOUGMC		_IOR(u,41,struct mconfig)   /* get mouse config */
#define TIOUSMC		_IOW(u,42,struct mconfig)   /* set mouse config */
#define TIOUCCON	_IO(u,47) 		    /* close console window */
#define TIOUOCON	_IO(u,48) 		    /* open console window */
#define TIOUGGLUT	_IOWR(u, 49, struct colorlut)    /* get global LUT */
#define TIOUSGLUT	_IOW(u, 50, struct colorlut)    /* set global LUT */

/*
 * The folllowing file defines names which can be used when
 * doing a write system call to the virtual screen.
 *	<function name>_f	function identifier
 *	<function name>_n	number of arguments to the function, -1
 *				if firsst argument to function 
 */

/* Numbers of function to be used after a write of a CS_DISPLAY_TOKEN */

typedef short		VT_ARG;		/* vt argument */
#define			VT_NSEQ	31	/* # of output write functions */

#define	SetPosition_f		 0
#define	SetPosition_n		 2	/* two args */

#define	SetXPosition_f		 1
#define	SetXPosition_n		 1	/* one arg */

#define	SetYPosition_f		 2
#define	SetYPosition_n		 1	/* one arg */

#define	BumpPosition_f		 3
#define	BumpPosition_n		 2	/* two args */

#define	BumpXPosition_f		 4
#define	BumpXPosition_n		 1	/* one arg */

#define	BumpYPosition_f		 5
#define	BumpYPosition_n		 1	/* one arg */

#define	PaintRectangleInterior_f 6
#define	PaintRectangleInterior_n 2	/* two args */

#define	PaintRectangleBorder_f	 7
#define	PaintRectangleBorder_n	 2	/* two args */

#define	CopyRegion_f		 8
#define	CopyRegion_n		 6	/* six args */

#define	MoveLocalCursor_f	 9
#define	MoveLocalCursor_n	 2	/* two args */

#define	HideLocalCursor_f	10
#define	HideLocalCursor_n	 0	/* no args */

#define	ShowLocalCursor_f	11
#define	ShowLocalCursor_n	 0	/* no args */

#define	SendNote_f		12
#define	SendNote_n		12	/* twelve args */

#define	SetFont_f		13
#define	SetFont_n		 1	/* one arg */

#define	SetPattern_f		14
#define	SetPattern_n		 1	/* one arg */

#define	SetJustification_f	15
#define	SetJustification_n	 1	/* one arg */

#define	SetThickness_f		16
#define	SetThickness_n		 1	/* one arg */

#define	SetPhase_f		17
#define	SetPhase_n		 2	/* two arg */

#define	SetAddressing_f		18
#define	SetAddressing_n		 1	/* one arg */

#define	InvertRegion_f		19
#define	InvertRegion_n		 4	/* two args */

#define	PaintPolygonInterior_f	20
#define	PaintPolygonInterior_n	-1	/* 33 args */

#define	PaintLine_f		21
#define	PaintLine_n		 2	/* two args */

#define	PaintCircleBorder_f	22
#define	PaintCircleBorder_n	 1	/* one arg */

#define	PaintCircleInterior_f	23
#define	PaintCircleInterior_n	 1	/* one arg */

#define	PaintArcBorder_f	24
#define	PaintArcBorder_n	 5	/* five args */

#define	PaintArcInterior_f	25
#define	PaintArcInterior_n	 5	/* five args */

#define PaintString_f		26     
#define PaintString_n		-1	/* number of args to follow */

#define SetCharAttributes_f	27
#define SetCharAttributes_n	 1	/* one arg, only use lower 8 bits */

#define PaintIcon_f		28
#define PaintIcon_n		 3	/* three args */

#define	SetBPattern_f		29
#define	SetBPattern_n		 1	/* one arg */

#define	SetColor_f		30
#define	SetColor_n		 1	/* one arg */

#define	SetBColor_f		31
#define	SetBColor_n		 1	/* one arg */

/*
 *	struct used to load in one soft function key name
 */
struct def_sfk {
	short		num;		    /* key number */
	bool		highlighted;	    /* highlight value */
	unsigned char   uname[VT_SCHARS];   /* upper name */
	unsigned char   lname[VT_SCHARS];   /* lower name */
};

/* 
 *	macro used to define cursors 
 */
#define BIN32(x30,x29,x28,x27,x26,x25,x24,x23,x22,x21,x20,x19,x18,x17,x16,x15,x14,x13,x12,x11,x10,x9,x8,x7,x6,x5,x4,x3,x2,x1,x0)  ( \
		(('x30'!=' ')<<30) | \
		(('x29'!=' ')<<29) | \
		(('x28'!=' ')<<28) | \
		(('x27'!=' ')<<27) | \
		(('x26'!=' ')<<26) | \
		(('x25'!=' ')<<25) | \
		(('x24'!=' ')<<24) | \
		(('x23'!=' ')<<23) | \
		(('x22'!=' ')<<22) | \
		(('x21'!=' ')<<21) | \
		(('x20'!=' ')<<20) | \
		(('x19'!=' ')<<19) | \
		(('x18'!=' ')<<18) | \
		(('x17'!=' ')<<17) | \
		(('x16'!=' ')<<16) | \
		(('x15'!=' ')<<15) | \
		(('x14'!=' ')<<14) | \
		(('x13'!=' ')<<13) | \
		(('x12'!=' ')<<12) | \
		(('x11'!=' ')<<11) | \
		(('x10'!=' ')<<10) | \
		(('x9'!=' ')<<9) | \
		(('x8'!=' ')<<8) | \
		(('x7'!=' ')<<7) | \
		(('x6'!=' ')<<6) | \
		(('x5'!=' ')<<5) | \
		(('x4'!=' ')<<4) | \
		(('x3'!=' ')<<3) | \
		(('x2'!=' ')<<2) | \
		(('x1'!=' ')<<1) | \
		(('x0'!=' '))

#endif
