#ifndef _VT_FONTS
#define _VT_FONTS

#ifdef	MAIN
#include "nbifont.h"
#else
#ifdef	KERNEL
#include "../vt/nbifont.h"
#include "ioctl.h"
#else	KERNEL
#include <vt/nbifont.h>
#include <sys/ioctl.h>
#endif	KERNEL
#endif

/*
 * Defines for VT to use in loading and using fonts.
 */

#define DEFNONPROPFONT	0	/* Default non-proportional font ID */
#define DEFWINDOWFONT	1	/* Default window font ID */
#define DEFTITLEFONT	2	/* Default title font ID */
#define DEFPROPFONT	3	/* Default proportional font ID */

#define MAXPLANES	32	/* Maximum number of font planes avail */
#define DEFPLANE	16	/* ASCII plane is the default */
#define	VTFONTPRI	PZERO+1	/* Priority for font daemon in sleep queue */
#define PLANEMSK	0x1f	/* Mask to remove high bits from plane esc */
#define CHARMSK		0x7f	/* Mask to remove high bits from character */
#define PLANEBASE	32	/* First printable character in a plane */
#define INVALIDFONT	0xffff	/* There cannot be a font with this ID no. */
/* KLUDGE: this should be based on screen size */
#define PLANESPACE	0x11000	/* small enough for MWS at 1024x1440 */


/*
 * Codes for types of requests that the storage daemon will recognize.
 */
#define	LOADFONT	0	/* Load a font */
#define REREADCAT	1	/* Re-read font catalog */

/*
 * Structure for storage daemon invalidate font plane ioctl.
 */
struct vt_inv_plane {
	unsigned short	fontid;		/* ID of font to invalidate */
	char		plane;		/* plane in font to be invalidated */
};

#ifndef MAIN
/*
 * Name to use when making ioctl call to have a font plane invalidated.
 */
#define FDIOINVP	_IOW(f, 01, struct vt_inv_plane)

/*
 * Define for making ioctl to force fontdaemon to re-read the font catalog.
 */
#define FDIORDCT	_IO(f, 02)
#endif

/*
 * Structure defining vt storage daemon requests.
 */
struct vt_daemon_request {
/* Header structure for VT storage daemon requests. */
	struct vt_daemon_request_header {
		unsigned short	sdrreqtype;	/* Type of request */
		int		sdrlength;	/* Length of data field */
	} reqhdr;
	union {
		struct font_request {	/* Font load request data */
			unsigned short	frfontid;	/* Fontid to load */
			char		frplane;	/* Plane to load */
		} fontreq;
	} reqdata;
#define font_reqdata	reqdata.fontreq
};

/*
 * Structure defining vt storage daemon replies.
 */
/*
 * Header structure for VT storage daemon replies.
 */
struct vt_daemon_reply_header {
	unsigned short	sdrreptype;	/* Type of reply */
	int		sdrlength;	/* Length of data field */
};

/*
 * Defines for permissible replies from the storage daemon.
 */
#define	PLANECHARDATA	0	/* Requested plane char. descriptors */
#define	NOSUCHPLANE	1	/* Plane not there, default plane returned */
#define	NOSUCHFONT	2	/* Font not there, default font returned */
#define NOSPACE		3	/* Not enough space in vid ram for rasters */
#define RASTTOOBIG	4	/* Rasters exceed maximum allowable size */
#define CATREREAD	5	/* Font catalog has been re-read */
#define NOCATALOG	6	/* Font catalog not found */

#if KERNEL | MAIN
/*
 * This structure contains the status of all loaded font planes.
 */
struct vt_font_table {
	struct vt_font_info {
		unsigned short	ftbfontid;	/* Font ID number */
		char		ftbplane;	/* Which plane in font */
		short		ftbinuse;	/* Plane reference count */
		long		ftblastuse;	/* Time plane last used */
		int		ftbrloc;	/* Loc. of rasters in vmem */
		int		ftbrlen;	/* Length of rasters */
	} ftbftplanes[MAXPLANES];	/* Entry for each possible plane */
};

/*
 * This structure contains all the character descriptors for each 
 * loaded plane.
 */
struct vt_plane_descriptors {
	struct font_plane	pldchardescripts[MAXPLANES];
				/* Character descriptors for each plane */
};

/*
 * This structure contains the status of all free memory segments in
 * video memory, the font rasters are allocated and freed from this
 * list.
 */
struct freelistentry {
	int		startaddr;	/* Start of free memory segment */
	int		length;		/* Length of free memory segment */
};

/*
 * This routine returns a pointer to a font plane descriptor array.
 * If the font plane is not one of the currently loaded font planes
 * then the plane will be loaded before the routine returns.
 */
struct font_plane *GetFontPlane(/* font, plane */);
/*	unsigned short	font;	* Font ID number *
 *	char		plane;	* Plane number *
 */

/*
 * This routine clears the in use flag on a font plane.  It should be called
 * after a string in a particular font and plane has been written out.
 */
DoneWithPlane(/* font, plane */);
/*	register unsigned short	font;	* Font ID number *
 *	register char		plane;	* plane number *
 */
#endif KERNEL | MAIN
#endif _VT_FONTS
