#include "../machine/reg.h"
#include "param.h"		/* system parameters */
#include "types.h"		/* system types */
#include "systm.h"		/* system sturcts et al */
#include "dir.h"		/* directories and files */
#include "user.h"		/* user block */
#include "file.h"		/* file structure */
#include "proc.h"		/* process strucutures */
#include "vnode.h"		/* inodes */
#include "conf.h"		/* cnofiguration */
#include "buf.h"		/* buffers */
#include "dk.h"			/* disk stuff */
#include "uio.h"		/* user input/output struct */
#include "kernel.h"		/* need lbolt and hz */
#include "signal.h"		/* signal defines */
#include "errno.h"		/* error defines */
#include "../vt/vt_hdrs.h"	/* virtual terminal parameters */
#include "../vt/vt_fonts.h"	/* font defines and structures */
#include "../vt/vt_output.h"	/* vt output defines */
#include "../vt/vt_kernel.h"	/* kernel only vt defines */
#include "../vt/vt_key.h"	/* external virtual key names */
#include "../vt/vt_keyin.h"	/* internal virtual key names */
#include "vm.h"
#include "msgbuf.h"
#include "../is68kdev/gpreg.h"

extern int		console_no;	/* major number of console */
extern struct tty	vt_tty[];	/* system wide virtual terms */
extern int		mactive, kactive;
extern short		mousex, mousey;
extern int		vtstart();
extern int		GPdaemonpid;
extern int		vt_loadfonts;
#ifdef	SYSV
extern int		sv_vtproc();
#endif	SYSV
extern short		popconsole; 		/* set in param.c */
short			vt_cnpoptop; 		/* pop console to top */
short			vt_cnpoptopsave;
short			vt_cnpoptopage = 0;	/* delay till next pop */
#define	VT_POPTOPAGE	120			/* # secs to top */

short			consx, consy, consw, consh; /* console position */

#define ISPEED 	B9600
#define IFLAGS	(EVENP|ODDP|ECHO|CRMOD)

/* open the desktop and window 1 for kernel printfs during startup */
vt_cninit()
{
	register struct tty *vp;

	if (!(gptype & GPEXISTS))	
	    return -1;

	mousex = 200; mousey = 300;

	/* initialize desktop */
	vp = &vt_tty[0];
	gpget();
	setupvt(vp);
	SetCharacterAttributes(vp->v_win, CLEARBACK);	/* for icons */
	vp->v_keyb = (*keybsw[vp->v_te=deskem].k_init)(vp);
	vp->v_term = (*termsw[vp->v_te].t_init)(vp);
	vp->t_state |= TS_CARR_ON|TS_ISOPEN;
#ifdef	SYSV
	map_state(vp, TOSV);
#endif	SYSV

	/* initialize console window */
	vt_cnpoptop = popconsole;
	vtcopen1(&vt_tty[NVT], TS_CARR_ON|TS_ISOPEN);
	gpgive();
	return(0);
}

vt_cnputc(c)
	char	c;
{
	register struct tty *vp = &vt_tty[NVT];
	int	gpdaemonpid_save, gptype_save, gpowner_save, vt_loadfonts_save;
	short	depth;

	/* no graphics processor? we're done! */
	if (!(gptype & GPEXISTS))	
	    return;

	/* pretend that we are not initialized, and have polled GIP */
	gpowner_save = u.u_procp->p_flag & SOWNGIP;
	gpdaemonpid_save = GPdaemonpid;		GPdaemonpid = 0;
	vt_loadfonts_save = vt_loadfonts;	vt_loadfonts = 0;
	gptype_save = gptype;			gptype &= ~GPUSEINT;
	gpget();

	/* use the console window's terminal emulator to display the char */
	vtctop();				/* create/forward window */
	if (c != '\0') {
	    if(c == '\n')
		(*termsw[vp->v_te].t_disp)(vp->v_term, '\r');
	    (*termsw[vp->v_te].t_disp)(vp->v_term, c);
	}

	/* return to reality */
	gpgive();
	gptype = gptype_save;
	vt_loadfonts = vt_loadfonts_save;
	GPdaemonpid = gpdaemonpid_save;
	u.u_procp->p_flag |= gpowner_save;
}


/* console open routine: line switched from /dev/console open  */
vtcopen(dev, flag)
	dev_t dev;
{
	struct tty	*vp = &vt_tty[NVT];
	int		error;
	short		depth;

	vt_cnpoptopage = VT_POPTOPAGE;
	if ((vp->t_state & TS_ISOPEN)==0) {
	    gpget();
	    vtcopen1(vp, TS_CARR_ON|TS_ISOPEN);
	    gpgive();
	}

#ifdef	SYSV
	map_state(vp, TOSV);
	if (u.u_procp->p_universe == UNIVERSE_SYSV)
		error =  ((*sv_linesw[vp->svt_line].l_open)(dev, vp));
	else
#endif	SYSV
		error = (*linesw[vp->t_line].l_open)(dev, vp);
	if (error)
	    return(error);
	if (vp->t_pgrp == 0 && u.u_procp)
	    vp->t_pgrp = u.u_procp->p_pgrp;
	return(0);
}

vtcopen1(vp, sflags)
	struct tty	*vp;
{
	vp->t_oproc = vtstart;
	vp->t_state |= sflags;
#ifdef	SYSV
	map_state(vp, TOSV);
	vp->svt_proc = sv_vtproc;
#endif	SYSV
	kactive = NVT;
	ttychars(vp);
	vp->t_ispeed = vp->t_ospeed = ISPEED;
	vp->t_flags = IFLAGS;
#ifdef	SYSV
	sv_ttinit(vp);
#endif	SYSV
	vp->v_win = (int *)CreateWindow(consx,consy,consw,consh,0,NORMAL);
	SetWindowTitle(vp->v_win, "Console");
	gsignal(vt_tty[0].t_pgrp, SIGREF);	/* tell dm about it */
	vtopen1(vp);
}

vtctop_aged()
{
	vt_cnpoptop = popconsole;
}

/* bring the console to the top */
vtctop()
{
	register struct tty *vp = &vt_tty[NVT];
	short	depth;

	if (panicstr) {
	    vt_cnpoptop = 1;
	    vt_cnpoptopage = 0;
	}

	if ((vp->t_state & TS_ISOPEN)==0)
	    vtcopen1(&vt_tty[NVT], TS_CARR_ON|TS_ISOPEN);
	else if (vt_cnpoptop) {
	    GetWindowDepth(vp->v_win, &depth);
	    if (depth) {
		ChangeWindowDepth(vp->v_win, 0);	/* make it top */
		gsignal(vt_tty[0].t_pgrp, SIGREF);
	    }
	    /* dont pop the console to the top for the next ?? seconds */
	    if (vt_cnpoptopage) {
	    	vt_cnpoptop = 0;
	    	timeout(vtctop_aged, 0, vt_cnpoptopage*hz);
	    }
	}
}

/* console close routine */
vtcclose(tp)
{
	/* no process group for console, but don't make it go away! */
	vt_tty[NVT].t_pgrp = 0;
}

/* console write routine: write to console vtty */
vtcwrite(tp, uio)
	register struct uio * uio;
{
	gpget(); vtctop(); gpgive();
	return(vtwrite(NVT, uio));
}

/* console read routine: read from console vtty */
vtcread(tp, uio)
	register struct uio * uio;
{
	gpget(); vtctop(); gpgive();
	return(vtread(NVT, uio));
}

/* console ioctl routine */
vtcioctl(tp, cmd, data, flag)
{
	int	error;

	gpget(); vtctop(); gpgive();
	if ((error = vtioctl(NVT, cmd, data, flag)) < 0)
		return(EIO);
	return(error);
}
