#include "param.h"		/* system parameters */
#include "systm.h"	/* */
#include "../vt/vt_hdrs.h"	/* virtual terminal parameters */
#include "../vt/vt_kernel.h"	/* kernel only vt defines */

#define ISKBD	/* use the is keyboard driver */

int	term_init(), term_disp(), term_change_font(), term_quit(),
	term_buffer_start(), term_buffer_stop(), term_mark(), 
	term_mark_stop();

int	gr_init(), gr_disp(), gr_ioctl(), gr_exit();
int	dt_init(), dt_disp(), dt_ioctl(), dt_exit();

/*
 *	The termsw table is used as the entry points for terminal emulators.
 *	each terminal emulator must supply an init, exit, and disp routine, 
 *	all other routines should be termsw_noop if not supported. Since the 
 *	terminal emulator can be set symbolically from outside the kernel, 
 *	it is important that each emulator have a unique name.
 */
termsw_noop(){ return (0);}

struct termsw termsw [] = {
	{"ansi (vt100)", term_init, term_disp, termsw_noop, 
	term_change_font, term_quit, term_buffer_start, 
	term_buffer_stop, term_mark, term_mark_stop}, 

	{"graphics", gr_init, gr_disp, gr_ioctl, termsw_noop, gr_exit,
	termsw_noop, termsw_noop, termsw_noop, termsw_noop},

	{"desktop", dt_init, dt_disp, dt_ioctl, termsw_noop, dt_exit,
	termsw_noop, termsw_noop, termsw_noop, termsw_noop},
};

/* declare the default emulator to be used when a window is opened */
int	defterm	= 0;
int	deskem	= 2;
int	nterms	= sizeof(termsw)/sizeof(struct termsw);

#ifdef	ISKBD
int	kb_init(), kb_keyin(), kb_mousein(), kb_exit(), kb_control();
#endif	ISKBD

/*
 *	The keybsw table is a structure parallel to the termsw table.  There
 *	must be an entry for each terminal emulator.  All entry points are 
 *	required except the mousein routine.
 */

struct keybsw keybsw [] = {
	/* window */
	kb_init,	kb_keyin,	kb_mousein,	
	kb_exit,	kb_control,

	/* graphics */
	kb_init,	kb_keyin,	kb_mousein,	
	kb_exit,	kb_control,

	/* desktop */
	kb_init,	kb_keyin,	kb_mousein,	
	kb_exit,	kb_control,

};

int	nkeybs	= sizeof(keybsw)/sizeof(struct keybsw);
