#include "param.h"
#include "dir.h"
#include "user.h"
#include "kernel.h"
#include "../wipc/wipc.h"

RmidToRpid(rmid)
	register unsigned long rmid;
{
	register unsigned long *p, *q;

	if ((rmid = MID(rmid)) == 0)
		return (unsigned long)0;
	q = &u.u_trpid[sizeof u.u_trpid/sizeof *q];
	for (p = u.u_trpid; p < q &&  *p;  p += 1)
		if (MID(*p) == rmid)
			return *p;
	return rmid | SERVER_PID;
}

NameToRpid(name)
	char *name;
{
	extern unsigned long NameToRmid();

	if (IsMyMName(name))
		return SELF_MID | SERVER_PID;
	return RmidToRpid(NameToRmid(name));
}

NameToRootRpid(name)
{
	/*
	 * This needs additional work!  We should be returning the rpid
	 *  corresponding to the machine containing name's root directory.
	 *  Thus if name refers to a diskless node we should return
	 *  the rpid (from our perspective of course) corresponding to
	 *  name's server.
	 */
	return NameToRpid(name);
}

EnterRpid(rpid)
	register unsigned long rpid;
{
	register unsigned long rmid;
	register unsigned long *p, *q;

	if ((rmid = MID(rpid)) == 0)
		return 0;
	q = &u.u_trpid[sizeof u.u_trpid/sizeof *q];
	for (p = u.u_trpid;  p < q;  p += 1) {
		if (*p == 0  ||  MID(*p) == rmid) {
			*p = rpid;
			return 1;
		}
		if (MID(*p) == rmid)
			return 0;
	}
	return 0;
}

DeleteRpid(rpid)
	register unsigned long rpid;
{
	register unsigned long *p, *q, *r;

	if (rpid == 0)
		return 0;
	q = &u.u_trpid[sizeof u.u_trpid/sizeof *q];
	for (p = u.u_trpid;  p < q;  p += 1) {
		if (*p == rpid) {
			for (r = p + 1;  r < q  &&  *r;  r += 1)
				;
			*p = *--r;
			*r = 0;
			return 1;
		}
	}
	return 0;
}
