/*
 * Rfsnode.h - 07/02/87
 */

/*
 * Remote file information structure.
 * The rnode is the "inode" for remote files.  It contains
 * all the information necessary to handle remote file on the
 * client side.
 */
struct rfsnode {
	struct rfsnode	*rf_next;	/* active rnode list */
	struct vnode	rf_vnode;	/* vnode for remote file */
	struct rfsmount	*rf_mntdev;	/* pointer into rfs mount structure */
	u_short	rf_flags;
	sndd_t	rf_fsptr;		/* eqvt of i_fsptr */
	long	rf_number;		/* eqvt of i_number */
	ushort	rf_ftype;
	short	rf_fstype;
	off_t	rf_size;		/* file size in bytes */
	struct ucred	*rf_cred;	/* current credentials */
#define	rf_uid	rf_cred->cr_uid
#define	rf_gid	rf_cred->cr_gid
	short	rf_nlink;
	dev_t	rf_dev;
};

/*
 * Flags	AS FOR NFS
 */
#define	RLOCKED		0x01		/* rnode is in use */
#define	RWANT		0x02		/* someone wants a wakeup */
#define	RATTRVALID	0x04		/* Attributes in the rnode are valid */
#define	REOF		0x08		/* EOF encountered on read */
#define	RDIRTY		0x10		/* dirty buffers may be in buf cache */
#define ROPEN		0x20		/* the vnode is currently open */

/*
 * Convert between vnode and rfsnode
 */
#define	RFSTOV(rp)	(&(rp)->rf_vnode)
#define	VTORFS(vp)	((struct rfsnode *)((vp)->v_data))

