/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"@(#)kern-port:sys/idtab.h	10.4"		*/
/*
 *
 *    defines for uid/gid translation.
 *
 */

#ifndef MAXSNAME
#define MAXSNAME	20
#endif
#define OTHERID		MAXUID+1
#define CFREE		0
#define CINUSE		1
#define CINTER		2
#define GLOBAL_CH	'.'	/* name of the "global" table	*/
#define UID_DEV		0	/* minor device number for uid device	*/
#define	GID_DEV		1	/* minor device number for gid device	*/
#define UID_MAP		UID_DEV
#define GID_MAP		GID_DEV

struct idtab	{
	unsigned short	i_rem;
	unsigned short	i_loc;
};
#define i_defval i_rem
#define i_tblsiz i_loc

struct idhead {
	unsigned short	i_default;
	unsigned short	i_size;
	unsigned short	i_cend;
	unsigned short	i_next;
	unsigned long	i_tries;
	unsigned long	i_hits;
};
#define HEADSIZE	(sizeof(struct idhead)/sizeof(struct idtab))
#ifdef KERNEL
extern ushort	glid();
extern char	rfheap[];
extern int	rfsize;

#define	gluid(a,b)	glid(UID_DEV,a,b)
#define glgid(a,b)	glid(GID_DEV,a,b)
#endif
