#ifdef	SYSV
struct	sysv_sysent	sysv_sysent[];
extern	int	nsysv_sysent;

/*
 * Called from the trap handler when a System V system call occurs
 */
/*ARGSUSED*/
sysv_syscall(exsf)
struct stkframe exsf;
{
	register int		*locr0 = ((int *)&psl)-PS;
	register struct timeval *tv = &u.u_ru.ru_stime;
	register struct sysv_sysent	*callp;
	register struct proc	*p;
	register int		i, t, x;
	register long		syst_tv_sec, syst_tv_usec;
#ifdef	RFS
	extern 	int bootstate;
#endif	RFS

	syst_tv_sec = u.u_ru.ru_stime.tv_sec;
	syst_tv_usec = u.u_ru.ru_stime.tv_usec;
	/*	sysinfo.syscall++;
		when this structure becomes available! */
	if (!USERMODE(locr0[PS])) {
#ifdef	SYSCALLTRACE
		if (syscalltrace)
			tprintf("PID%d:%s:%x: ",u.u_procp->p_pid,u.u_comm,pc);
#endif	SYSCALLTRACE
		panic("syscall");
	}

#ifdef	SYSCALLTRACE
	if (syscalltrace)
		tprintf("PID%d:%s:%x: ",u.u_procp->p_pid,u.u_comm,pc);
#endif	SYSCALLTRACE
	u.u_ar0 = locr0;

	if (u.u_procp->p_universe != UNIVERSE_SYSV && !sysv_syscomm(code)) {
		u.u_code = 0;
		psignal(u.u_procp, SIGEMT);
		goto done;
	}
	u.u_procp->p_systemcall = code;
		/* System V keeps the code in u area! */
	u.u_error = 0;
	callp = (code >= nsysv_sysent-1 || code < 0) ? 
				&sysv_sysent[nsysv_sysent-1] : &sysv_sysent[code];
				/* Args were copied in locore.s */
	u.u_r.r_val1 = 0;
	u.u_r.r_val2 = locr0[R1];
	u.u_ap = u.u_arg;

	u.u_eosys = JUSTRETURN;
	i = u.u_sigintr;
	u.u_sigintr = -1;/* All signals can interrupt System V call */
#ifdef	RFS
	if ((bootstate || !callp->sy_setjmp) && setjmp(&u.u_qsave)) {
		if (!(u.u_rflags & U_RSYS) && !u.u_error)
			u.u_error = EINTR;
	} else
		(*callp->sy_call)(u.u_ap);

	u.u_rflags &= ~(U_RSYS | U_DOTDOT | U_LBIN);
#else	RFS
	if ((!callp->sy_setjmp) && setjmp(&u.u_qsave)) {
			u.u_error = EINTR;
	} else
		(*callp->sy_call)(u.u_ap);
#endif	RFS

	/*
	 * System V does not restart system calls if they are interrupted.
	 * So the RESTARTSYS even if set is not honored!!
	 */
#ifdef	notdef
	if (u.u_eosys == SIMULATERTI)
		dorti();
	else
#endif
	if (u.u_error) {
#ifdef	DEBUGGER
		if (show_error)
			tprintf("syscall %x: err %x: PID %d: %s\n", code,
				u.u_error, u.u_procp->p_pid, u.u_comm);
#endif	DEBUGGER
		locr0[R0] = u.u_error;
		locr0[PS] |= PSL_C;		/* carry bit */
	} else {
		locr0[PS] &= ~PSL_C;
		locr0[R0] = u.u_r.r_val1;
		locr0[R1] = u.u_r.r_val2;
	}
done:
	p = u.u_procp;
	if (p->p_cursig || ISSIG(p))
		psig();
	p->p_pri = p->p_usrpri;
	if (runrun) {
		/*
		 * Since we are u.u_procp, clock will normally just change
		 * our priority without moving us from one queue to another
		 * (since the running process is not on a queue.)
		 * If that happened after we setrq ourselves but before we
		 * swtch()'ed, we might not be on the queue indicated by
		 * our priority.
		 */
		(void) spl6();
		setrq(p);
		u.u_ru.ru_nivcsw++;
		swtch();
	}
	if (u.u_prof.pr_scale) {
		/* dont generate tmps */
		t = (tv->tv_sec - syst_tv_sec) * 1000;
		i = (tv->tv_usec - syst_tv_usec) / 1000;
		x = tick / 1000;
		t += i;
		t /= x;
		if (t)
			addupc(locr0[PC], &u.u_prof, t);
	}
	curpri = p->p_pri;
#ifdef	SYSCALLTRACE
	if (syscalltrace)
		tprintf(" :%x:PID%d\n",pc,u.u_procp->p_pid);
#endif	SYSCALLTRACE
	asm("	.globl	_sysv_syscall_end; _sysv_syscall_end:");
}

#endif	SYSV
