#ifdef	SYSV
/*
 *	Gateway to 4.3
 */

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include	"../h/param.h"
#include 	"../h/types.h"
#include	"../h/user.h"
#include 	"../h/systm.h"
#include 	"../h/dir.h"
#include 	"../h/kernel.h"
#include 	"../h/proc.h"
#include 	"../h/vnode.h"
#include 	"../h/file.h"
#include 	"../h/inode.h"
#include 	"../sysv/sys/sysmacros.h"

/*
 * Everything in this file is a routine implementing a system call.
 */


gtime()
{
	u.u_r.r_time = time.tv_sec;
}

stime(uap)
	register struct a {
		int	time;
	} *uap;
{
	struct timeval tv;

	tv.tv_sec = uap->time;
	tv.tv_usec = 0;
	setthetime(&tv);
	if(suser()) rem_date();
}

#ifndef	RFS
rem_date()
{
/* Until RFS is ready */
}
#endif	not RFS

#include "../h/quota.h"
/*
 * This is taken from 4.1 compatile stuff is not really as it
 * should be in System V
 */
sysv_setuid(uap)
	register struct a {
		int	uid;
	} *uap;
{
	register uid;

	uid = uap->uid;
	if (uid >= MAXUID) {
		u.u_error = EINVAL;
		return;
	}
	if(u.u_uid && (uid == u.u_ruid || uid == u.u_procp->p_suid)) {
		u.u_cred = crcopy(u.u_cred);
		u.u_uid = uid;
	} else if (suser()) {
#ifdef BSD_QUOTA
		if (u.u_quota->q_uid != uid) {
			qclean();
			qstart(getquota(uid, 0, 0));
		}
#endif
		u.u_cred = crcopy(u.u_cred);
		u.u_uid = uid;
		u.u_procp->p_uid = uid;
		u.u_procp->p_suid = uid;
		u.u_ruid = uid;
	}
}

/*
 * This is from 4.1 compatible stuff
 */
sysv_setgid(uap)
	register struct a {
		int	gid;
	} *uap;
{
	register gid;

	gid = uap->gid;
	if (gid >= MAXUID) {
		u.u_error = EINVAL;
		return;
	}
	if(u.u_uid && (gid == u.u_rgid || gid == u.u_procp->p_sgid)) {
		u.u_cred = crcopy(u.u_cred);
		u.u_gid = gid;
	} else if (suser()) {
		u.u_cred = crcopy(u.u_cred);
		leavegroup(u.u_rgid);
		(void) entergroup(gid);
		u.u_gid = gid;
		u.u_procp->p_sgid = gid;
		u.u_rgid = gid;
	}
}

sysv_setpgrp(uap)
	register struct a {
		int	flag;
	} *uap;
{
	register struct proc *p = u.u_procp;

	if (uap->flag) {
		if (p->p_pgrp != p->p_pid)
			u.u_ttyp = NULL;
		p->p_pgrp = p->p_pid;
	}
	u.u_r.r_val1 = p->p_pgrp;
}

/*
 * As implemented by 4.1 compatible interface
 * May not entirely comply with SVID yet
 */

nice(uap)
	register struct a {
		int	niceness;
	} *uap;
{
	register struct proc *p = u.u_procp;

	donice(p, (p->p_nice-NZERO) + uap->niceness);
	u.u_r.r_val1 = p->p_nice;
}

sysv_chroot(uap)
	struct a {
		char	*dirnamep;
	} *uap;
{

	if (!suser())
		return;
	chroot(uap);			/* call 4.3 */
}


/* Ssig() is the common entry for signal, sigset, sighold, sigrelse,
sigignore and sigpause */
/*
 * There are no spl calls here unlike Bsd!
 */

ssig(uap)
	struct a {
		int	signo;
		int	(*fun)();
	} *uap;
{
	register a;
	register struct proc *p;
	int mask;

	a = uap->signo & SIGNO_MASK;
	if (a <= 0 || a >= NSIG || a == SIGKILL) {
		u.u_error = EINVAL;
		return;
	}
	mask = (1L<<(a-1));
	p = u.u_procp;
	switch (uap->signo & ~SIGNO_MASK) {

	case SIGHOLD:	/* sighold */
		p->p_sigmask |= mask;
		u.u_r.r_val1 = 0;
		return;

	case SIGRELSE:	/* sigrelse */
		p->p_sigmask &= ~mask;
		u.u_r.r_val1 = 0;
		return;

	case SIGIGNORE:	/* signore */
		u.u_signal[a] = SIG_IGN;
		p->p_sig &= ~mask;
		p->p_sigmask &= ~mask;
		p->p_sigignore |= mask;
		p->p_sigcatch &= ~mask;
		u.u_sigonstack &= ~mask; /* This may be redundant */
		u.u_r.r_val1 = 0;
		return;

	case SIGPAUSE:	/* sigpause */
		p->p_sigmask &= ~mask;
		u.u_r.r_val1 = 0;
		pause();
		/* not reached */

	case SIGDEFER:		/* sigset */
		if (uap->fun != SIG_DFL && uap->fun != SIG_IGN
			&& uap->fun != SIG_HOLD_SV)
			p->p_chold |= mask;
		if (p->p_sigmask & mask)
			u.u_r.r_val1 = (int) SIG_HOLD_SV;
		else
			u.u_r.r_val1 = (int) u.u_signal[a];
		if (uap->fun == SIG_HOLD_SV) {
			p->p_sigmask |= mask;
		} else {
			u.u_signal[a] = uap->fun;
			p->p_sigmask &= ~mask;
			if(uap->fun == SIG_IGN) {
				p->p_sig &= ~mask;
				p->p_sigignore |= mask;
				p->p_sigcatch &= ~mask;
			} else {
				p->p_sigignore &= ~mask;
				if(uap->fun == SIG_DFL)
					p->p_sigcatch &= ~mask;
				else
					p->p_sigcatch |= mask;
			}
		}
		u.u_sigonstack &= ~mask; /* This may be redundant */
		break;

	case 0:	/* signal */
		p->p_chold &= ~mask;
		u.u_r.r_val1 = (int) u.u_signal[a];
		u.u_signal[a] = uap->fun;
		/* p_sig only cleared in signal, not in sigset */
		p->p_sig &= ~mask;
		if(uap->fun == SIG_IGN) {
			p->p_sigignore |= mask;
			p->p_sigcatch &= ~mask;
		} else {
			p->p_sigignore &= ~mask;
			if(uap->fun == SIG_DFL)
				p->p_sigcatch &= ~mask;
			else
				p->p_sigcatch |= mask;
		}
		u.u_sigonstack &= ~mask;	/* This may be redundant */
		break;

	default:		/* error */
		u.u_error = EINVAL;
		return;
	}
	
	if (a == SIGCLD_SV) {
		for (p = u.u_procp->p_cptr ; p ; p = p->p_osptr) {
			if (p->p_stat == SZOMB)
				psignal(u.u_procp, SIGCLD_SV);
		}
	}
}

#include "../h/times.h"

/*
 * From 4.1 compatible interface
 */

times(uap)
	register struct a {
		struct	tms *tmsb;
	} *uap;
{
	struct tms atms;

	atms.tms_utime = scale60(&u.u_ru.ru_utime);
	atms.tms_stime = scale60(&u.u_ru.ru_stime);
	atms.tms_cutime = scale60(&u.u_cru.ru_utime);
	atms.tms_cstime = scale60(&u.u_cru.ru_stime);
	u.u_error = copyout((caddr_t)&atms, (caddr_t)uap->tmsb, sizeof (atms));
	u.u_r.r_time = lbolt;
}

scale60(tvp)
	register struct timeval *tvp;
{

	return (tvp->tv_sec * 60 + tvp->tv_usec / 16667);
}

/*
 * Profiling
 */

/*
 * alarm clock signal
 */
alarm(uap)
	register struct a {
		int	deltat;
	} *uap;
{
	register struct proc *p = u.u_procp;
	int s = splhigh();

	untimeout(realitexpire, (caddr_t)p);
	timerclear(&p->p_realtimer.it_interval);
	u.u_r.r_val1 = 0;
	if (timerisset(&p->p_realtimer.it_value) &&
	    timercmp(&p->p_realtimer.it_value, &time, >))
		u.u_r.r_val1 = p->p_realtimer.it_value.tv_sec - time.tv_sec;
	if (uap->deltat == 0) {
		timerclear(&p->p_realtimer.it_value);
		splx(s);
		return;
	}
	p->p_realtimer.it_value = time;
	p->p_realtimer.it_value.tv_sec += uap->deltat;
	timeout(realitexpire, (caddr_t)p, hzto(&p->p_realtimer.it_value));
	splx(s);
}

/*
 * indefinite wait.
 * no one should wakeup(&u)
 */
pause()
{

	for (;;)
		sleep((caddr_t)&u, PSLEP);
}

/*
 * mode mask for creation of files
 */
sysv_umask(uap)
	register struct a {
		int	mask;
	} *uap;
{
	register t;

	t = u.u_cmask;
	u.u_cmask = uap->mask & PERMMSK;
	u.u_r.r_val1 = t;
}

/*
 * Set IUPD and IACC times on file.
 * Can't set ICHG.
 * From 4.1
 */
utime(uap)
	register struct a {
		char	*fname;
		time_t	*tptr;
	} *uap;
{
	struct vattr vattr;
	time_t tv[2];

	vattr_null(&vattr);
	if (uap->tptr != NULL) {

#ifdef	RFS
		if (server())	/* server already copied time in */
			bcopy((caddr_t)uap->tptr, (caddr_t)tv, sizeof(tv));
		else
#endif	RFS
			if (u.u_error = copyin((caddr_t)uap->tptr, (caddr_t)tv,
							sizeof (tv)))
				return;
		vattr.va_atime.tv_usec = -1;
	} else {
		tv[0] = time.tv_sec;
		tv[1] = time.tv_sec;
		vattr.va_atime.tv_usec = 0;
	}
	vattr.va_atime.tv_sec = tv[0];
	vattr.va_mtime.tv_sec = tv[1];
	vattr.va_mtime.tv_usec = 0;
	u.u_error = namesetattr(uap->fname, FOLLOW_LINK, &vattr);
}

sysv_ulimit(uap)
	register struct a {
		int	cmd;
		long	arg;
	} *uap;
{
	switch (uap->cmd) {

	case 2:	{	/* Set new file size limit. */
		register unsigned long newlimit;

		newlimit = uap->arg << 9;
		if (newlimit > u.u_rlimit[RLIMIT_FSIZE].rlim_max && !suser()) {
			u.u_error = EPERM;
			return;
		}
		if (newlimit > RLIM_INFINITY) {
			u.u_error = EFBIG;
			return;
		}
		u.u_rlimit[RLIMIT_FSIZE].rlim_max = 
		u.u_rlimit[RLIMIT_FSIZE].rlim_cur =
		u.u_rlimit[RLIMIT_CORE].rlim_max =
		u.u_rlimit[RLIMIT_CORE].rlim_cur = newlimit;
		u.u_r.r_off = newlimit >> 9;
	}

	case 1:	/* Return current file size limit. */
		u.u_r.r_off = u.u_rlimit[RLIMIT_FSIZE].rlim_max >> 9;
		break;

	case 3:	/* Return maximum possible break value. */
		u.u_r.r_off = u.u_rlimit[RLIMIT_DATA].rlim_max;
		break;
	case 4:	/* Return configured value of NOFILES. */
		u.u_r.r_off = NOFILE;
		break;

	default:
		u.u_error = EINVAL;
	}
}

/*
 * KLUDGE: routine to see if a vnode's underlying inode has only 1 link
 * left
 */
sysv_lastlink(vp)
struct vnode *vp;
{
	if (vp->v_op == &ufs_vnodeops && (VTOI(vp))->i_nlink == 1)
		return 1;
	else
		return 0;
}
#endif SYSV
