#ifdef	SYSV
/*
 *	Gateway to 4.3.
 *	Some system V calls come here before finding
 *	their way to rest of the 4.3 code!
 */


/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"@(#)kern-port:os/sys2.c	10.20"		*/

#include	"param.h"
#include	"user.h"
#include	"../sysv/sys/fcntl.h"
#include	"file.h"
#include 	"uio.h"
#include	"proc.h"
#include	"vnode.h"
#include	"../specfs/snode.h"
#include	"kernel.h"
#include	"../sysv/sys/stropts.h"
#include	"../sysv/sys/stream.h"
#include	"../sysv/sys/poll.h"
#include	"../sysv/sys/signal.h"
#include	"../sysv/sys/errno.h"
#include	"../sysv/sys/debug.h"
#include	"../sysv/sys/fs/s5dir.h"

/*
 * open system call
 */
sysv_open(uap)
	register struct a {
		char	*fname;
		int	mode;
		int	crtmode;
	} *uap;
{
	register unsigned i;

	/*
	 * Some jugglery with mode bits as they are not the same
	 * in System V and 4.3 Bsd
	 */
	uap->mode &= ~O_SYNC;	/* Not yet implemented */
	i = uap->mode & SYSV_BITS;
	uap->mode &= ~SYSV_BITS;
	uap->mode |= (i << 1);
	open(uap);		/* time to call 4.3 */
}


/*
 * getmsg system call
 */
getmsg()
{
	u.u_error = msgio(FREAD);
}

/*
 * putmsg system call
 */
putmsg()
{
	u.u_error = msgio(FWRITE);
}

/*
 * common code for recv and send calls:
 * check permissions, copy in args, preliminary setup,
 * and switch to appropriate stream routine
 */
msgio(mode)
register mode;
{
	register struct file *fp;
	register struct snode *sp;
	register struct vnode *vp;
	register struct a {
		int		fdes;
		struct strbuf	*ctl;
		struct strbuf	*data;
		int		flags;
	} *uap;
	struct strbuf msgctl, msgdata;
	int error = 0;

	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fdes)) == NULL)
		return u.u_error;
	if (!(fp->f_flag&mode)) {
		return EBADF;
	}

	if ((fp->f_type != DTYPE_VNODE) ||
		!(vp = (struct vnode *)fp->f_data) || (vp->v_type != VCHR) ||
		!(sp = VTOS(vp)) || !(sp->s_sptr)) {
		return ENOSTR;
	}
	if (uap->ctl) {
		if (copyin((caddr_t)uap->ctl, (caddr_t)&msgctl, 
		    sizeof(struct strbuf))) {
			return EFAULT;
		}
	}
	if (uap->data) {
		if (copyin((caddr_t)uap->data, (caddr_t)&msgdata,
		   sizeof(struct strbuf))) {
			return EFAULT;
		}
	}
	if (mode == FREAD) {
		if (!uap->ctl)
			msgctl.maxlen = -1;
		if (!uap->data)
			msgdata.maxlen = -1;
		u.u_r.r_val1 = strgetmsg(sp, &msgctl, &msgdata, uap->flags);
		if (u.u_error)
			return u.u_error;
		if ((uap->ctl && copyout((caddr_t)&msgctl,
				(caddr_t)uap->ctl, sizeof(struct strbuf))) ||
		    (uap->data && copyout((caddr_t)&msgdata,
				(caddr_t)uap->data, sizeof(struct strbuf)))) {
			return EFAULT;
		}
		return error;
	}
	/*
	 * FWRITE case 
	 */
	if (!uap->ctl)
		msgctl.len = -1;
	if (!uap->data)
		msgdata.len = -1;
	strputmsg(sp, &msgctl, &msgdata, uap->flags);
	return u.u_error;
}

/*
 * Poll system call
 */

int pollwait;

poll(uap)
	register struct uap  {
		struct	pollfd *fdp;
		unsigned long nfds;
		long	timo;
	} *uap;
{
	struct pollfd pollfd[NPOLLFILE];
	caddr_t fdp;
	register fdcnt = 0;
	register int i, j, s;
	extern long lbolt;
	long olbolt;
	int rem;
	struct file *fp;
	struct snode *sp;
	int polltime();
	struct strevent *timeproc;
	int size;
	int mark;

	if (uap->nfds < 0 || uap->nfds > NOFILE) {
		u.u_error = EINVAL;
		return;
	}
	olbolt = lbolt;

	/*
	 * retry scan of fds until an event is found or until the
	 * timeout is reached.
	 */
retry:		

	/*
	 * Polling the fds is a relatively long process.  Set up the SPOLL
	 * flag so that we can see if something happened
	 * to an fd after we checked it but before we go to sleep.
	 */
	u.u_procp->p_flag |= SPOLL;

	/*
	 * Check fd's for specified events.  
	 * Read in pollfd records in blocks of NPOLLFILE.  Test each fd in the block
	 * and store the result of the test in the event field of the in-core
	 * record.  After a block of fds is finished, write the result out
	 * to the user.  Note that if no event is found, the whole procedure
	 * will be repeated after awakenening from the sleep (subject to timeout).
	 */

	mark = uap->nfds;
	size = 0;
	fdp = (caddr_t)uap->fdp;
	for (i = 0; i < uap->nfds; i++) {
		j = i % NPOLLFILE;
		/*
		 * If we have looped back around to the base of pollfd,
		 * write out the results of the strpoll calls kept in pollfd
		 * to the user fdp.  Read in the next batch of fds to check.
		 */
		if (!j) {
			if (i > 0) {
				ASSERT(size == NPOLLFILE*sizeof(struct pollfd));
				if (copyout(pollfd, fdp, size)) {
					u.u_error = EFAULT;
					return;
				}
				fdp += size;
			}
			size = MIN(uap->nfds - i, NPOLLFILE) * sizeof(struct pollfd);
			if (copyin((caddr_t)uap->fdp, (caddr_t)pollfd, size)) {
				u.u_error = EFAULT;
				return;
			}
		}

		if (pollfd[j].fd < 0) 
			pollfd[j].revents = 0;
		else if ((pollfd[j].fd >= NOFILE) ||
			  !(fp = u.u_ofile[pollfd[j].fd]) || 
			  (fp->f_type != DTYPE_VNODE) ||
			  (((struct vnode *)fp->f_data)->v_type != VCHR) ||
			  !(sp = VTOS((struct vnode *)fp->f_data)) ||
			  !(sp->s_sptr))
			pollfd[j].revents = POLLNVAL;
		else {
			pollfd[j].revents = strpoll(sp->s_sptr, 
						     pollfd[j].events, fdcnt);
			if (u.u_error) {
				if (!fdcnt) mark = i;
				goto pollout;
			}
		}
		if (pollfd[j].revents && !fdcnt++) mark = i;
	}

	/*
	 * Poll of fds completed.  
	 * Copy out the last batch of events.  If the poll was successful, 
	 * return fdcnt to user.
	 */
	u.u_r.r_val1 = fdcnt;
	if (copyout((caddr_t)pollfd, fdp, size)) {
		u.u_error = EFAULT;
		return;
	}
	if (fdcnt) 
		goto pollout;

	/*
	 * If you get here, the poll of fds was unsuccessful.
	 * First make sure your timeout hasn't been reached.
	 * If not then sleep and wait until some fd becomes
	 * readable, writeable, or gets an exception.
	 */
	rem = ( (uap->timo < 0) ? 1 : (uap->timo - ((lbolt-olbolt)*1000)/hz) );
	if (rem <= 0)
		goto pollout;

	s = spl6();
	/*
	 * If anything has happened on an fd since it was checked, it will
	 * have turned off SPOLL.  Check this and rescan if so.
	 */
	if (!(u.u_procp->p_flag & SPOLL)) {
		splx(s);
		goto retry;
	}
	u.u_procp->p_flag &= ~SPOLL;

	if (!(timeproc = sealloc(SE_SLEEP))) {
		splx(s);
		u.u_error = EAGAIN;
		goto pollout;
	}
	timeproc->se_procp = u.u_procp;
	if (uap->timo > 0) 
		timeout(polltime, timeproc, (rem*hz+999)/1000);

	/*
	 * The sleep will usually be awakened either by this poll's timeout 
	 * (which will have nulled timeproc), or by the strwakepoll function 
	 * called from a stream head.
	 */
	if (sleep((caddr_t)&pollwait, (PZERO+1)|PCATCH)) {
		if (uap->timo > 0)
			untimeout(polltime,timeout);
		splx(s);
		u.u_error = EINTR;
		sefree(timeproc);
		goto pollout;
	}
	splx(s);
	if (uap->timo > 0)
		untimeout(polltime,timeout);

	/*
	 * If timeproc is not NULL, you were probably awakened because a
	 * write queue emptied, a read queue got data, or an exception
	 * condition occurred.  If so go back up and poll fds again.
	 * Otherwise, you've timed out so you will fall thru and return.
	 */
	if (timeproc->se_procp) {
		sefree(timeproc);
		goto retry;
	}
	sefree(timeproc);

pollout:

	/*
	 * Poll general cleanup code. Go back to all of the streams 
	 * before the mark and reset the wakeup mechanisms that were 
	 * set up during the poll.  
	 */
	u.u_procp->p_flag &= ~SPOLL;
	fdp = (caddr_t)uap->fdp;
	for (i = 0; i < mark; i++) {
		j = i % NPOLLFILE;
		/*
		 * Read in next block of pollfds.  If the total number of pollfds
		 * is less than NPOLLFILE, don't bother because the pollfds of 
		 * interest are still in the pollfd[] array.
		 */
		if (!j && (uap->nfds > NPOLLFILE)) {
			size = MIN(uap->nfds - i, NPOLLFILE) * sizeof(struct pollfd);
			if (copyin((caddr_t)uap->fdp, (caddr_t)pollfd, size)) {
				u.u_error = EFAULT;
				return;
			}
			fdp += size;
		}

		if (pollfd[j].fd < 0)
			continue;
		if ((fp = getf(pollfd[j].fd)) == NULL)
			continue;
		if  ((fp->f_type != DTYPE_VNODE) ||
		    (((struct vnode *)fp->f_data)->v_type != VCHR) ||
		    !(sp = VTOS((struct vnode *)fp->f_data)) ||
		    !(sp->s_sptr))
			continue;
		pollreset(sp->s_sptr);
	}
	return;
}

/*
 * Removes all event cells that refer to the current process in the
 * given stream's poll list.
 */
pollreset(stp)
register struct stdata *stp;
{
	register struct strevent *psep, *sep, *tmp;
	
	sep = stp->sd_pollist;
	psep = NULL;
	while (sep) {
		tmp = sep->se_next;
		if (sep->se_procp == u.u_procp) {
			if (psep)
				psep->se_next = tmp;
			else
				stp->sd_pollist = tmp;
			sefree(sep);
		}
		sep = tmp;
	}
	/*
	 * Recalculate pollflags
	 */
	stp->sd_pollflags = 0;
	for (sep = stp->sd_pollist; sep; sep = sep->se_next)
		stp->sd_pollflags |= sep->se_events;
}

/*
 * This function is placed in the callout table to time out a process
 * waiting on poll.  If the poll completes, this function is removed
 * from the table.  Its argument is a pointer to a variable which holds
 * the process table pointer for the process to be awakened.  This
 * variable is nulled to indicate that polltime ran.
 */
polltime(timeproc)
struct strevent *timeproc;
{
	register struct proc *p = timeproc->se_procp;

	if (p->p_wchan == (caddr_t)&pollwait) {
		setrun(p);
		timeproc->se_procp = NULL;
	}
}

/*
 * getdents system call
 */
getdents(uap)
	register struct a {
		int fd;
		char *buf;
		int nbytes;
	} *uap;
{
	struct file *fp;
	struct uio auio;
	struct iovec aiov;
	struct vnode *vp;

	u.u_error = getvnodefp(uap->fd, &fp);
	if (u.u_error)
		return;
	if ((fp->f_flag & FREAD) == 0) {
		u.u_error = EBADF;
		return;
	}
	vp = (struct vnode *)fp->f_data;
	if (vp->v_type != VDIR ) {
		u.u_error = ENOTDIR;
		return;
	}
	aiov.iov_base = uap->buf;
	aiov.iov_len = uap->nbytes;
	auio.uio_iov = &aiov;
	auio.uio_iovcnt = 1;
	auio.uio_offset = fp->f_offset;
	auio.uio_offset_sysv = fp->f_offset_sysv;
	auio.uio_offset_buf = fp->f_offset_buf;
	auio.uio_seg = UIOSEG_USER;
	auio.uio_resid = uap->nbytes;
	u.u_error = VOP_S5GETDENTS(vp, &auio, fp->f_cred, 0);
	u.u_r.r_val1 = uap->nbytes - auio.uio_resid;
	fp->f_offset = auio.uio_offset;
	fp->f_offset_sysv = auio.uio_offset_sysv;
	fp->f_offset_buf = auio.uio_offset_buf;
}
#endif SYSV
