#ifdef	SYSV
#include "param.h"
#include "user.h"
#include "proc.h"
#include "text.h"
#include "../sysv/sys/lock.h"

lock()
{
	register struct proc * p = u.u_procp;
	register struct text * xp = p->p_textp;
	register int size;

	struct a {
		long oper;
	};

	if (!suser())
		return;

	switch ((int)(((struct a *)u.u_ap)->oper)) {
	case TXTLOCK:
		if ((xp == NULL) || (p->p_flag&SXLOCK) || (textlock() == 0))
			goto bad;
		break;
	case PROCLOCK:
		if ((xp == NULL) || (p->p_flag&SXLOCK) || (textlock() == 0))
			goto bad;
		if ((p->p_flag&SPLOCK) || (datalock() == 0)) {
			tunlock();
			goto bad;
		}
		break;
	case DATLOCK:
		if ((p->p_flag&SPLOCK) || (datalock() == 0))
			goto bad;
		break;
	case UNLOCK:
		if (punlock() == 0)
			goto bad;
		break;

	default:
bad:
		if (u.u_error == 0)
			u.u_error = EINVAL;
	}
}
#endif	SYSV
