/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"@(#)kern-port:nudnix/rnami.c	10.3"		*/

#if	defined(SYSV) && defined(RFS)
#include "../h/types.h"
#include "../sysv/sys/sema.h"
#include "../sysv/sys/sysmacros.h"
#include "../h/param.h"
#include "../sysv/sys/errno.h"
#include "../h/user.h"
#include "../sysv/sys/comm.h"
#include "../sysv/sys/mount.h"
#include "../h/proc.h"
#include "../h/vnode.h"
#include "../h/pathname.h"
#include "../sysv/sys/debug.h"
#include "../sysv/sys/rdebug.h"
#include "../sysv/sys/systm.h"
	/**************************
	#include "sys/fs/s5dir.h"
	#include "sys/signal.h"
	#include "sys/immu.h"
	#include "sys/psw.h"
	#include "sys/pcb.h"
	#include "sys/inode.h"
	#include "sys/file.h"
	#include "sys/region.h"
	#include "sys/inline.h"
	**************************/

extern	struct	vnode *rem_vnode(); 

/* come here from namei()/lookuppn when root dir or current dir is REMOTE */
/* return code:  -1: error, 0: cross mount point again */ 

rnamei1(dirp, dpp)
register struct vnode *dirp;	/* either root dir or current dir */
struct vnode **dpp;
{
	register struct vnode *dp;

 	*dpp = dp = remote_call(dirp, (caddr_t)NULL); 
	if (dp == NULL) 
		return (-1);
 	if (u.u_rflags & U_DOTDOT) {
		u.u_rflags &= ~U_DOTDOT;
		return (0);
 	}
 	if (u.u_rflags & U_RSYS)
 		return (1);
	/* remote inode case for dufst */
	if (dp->v_flag & VRFSNODE)
		return (1);
	panic ("rnamei1");	
	/*NOTREACHED*/
}



/* come here from namei()/lookuppn when dp->v_flag & (VDOTDOT) is true */
/* check if I am server(), if so, if I want to do '..' at a REMOTE mount point */
/* return EDOTDOT so that server goes back to client */

/*ARGSUSED*/
rnamei2(comp, vp, pnp)
char *comp;
register struct vnode *vp;
register struct pathname *pnp;
{
	register struct srmnt *smp;

	smp = &srmount[u.u_mntindx];
	if (vp == smp->sr_rootvnode) 
		if(vp->v_flag & VDOTDOT)  {
			/*	VN_RELE(vp);	*/
			/* vp will be released by lookuppn */
			goback(smp->sr_mntindx, DOT_DOT, pnp);
			return(u.u_error);
		}
		else  /* lbin case, now mnt index is parent */
			u.u_mntindx = smp->sr_dotdot;
	return(0);
}
#endif	defined(SYSV) && defined(RFS)
