/*
 * rfs_vfsops.c 87/01/27
 */

#if	defined(SYSV) && defined(RFS)
#include "../h/param.h"
#include "../h/types.h"
#include "../h/user.h"
#include "../h/vfs.h"
#include "../h/vnode.h"
#include "../h/pathname.h"
#include "../h/uio.h"
#include "../sysv/sys/rdebug.h"
#include "../sysv/sys/sema.h"
#include "../sysv/sys/comm.h"
#include "../sysv/sys/mount.h"
#include "../sysv/sys/rfsnode.h"
#include "../sysv/sys/statfs.h"


struct vnode *makerfsnode();

/*
 * rfs vfs operations.
 */
int Rfs_mount();
int Rfs_umount();
int Rfs_root();
int Rfs_statfs();
int Rfs_sync();
int Rfs_vget();

struct vfsops rfs_vfsops = {
	Rfs_mount,
	Rfs_umount,
	Rfs_root,
	Rfs_statfs,
	Rfs_sync,
	Rfs_vget,
};

/*
 * Flush any pending I/O.
 */
int
Rfs_sync(vfsp)
	struct vfs * vfsp;
{
	int tmpsyscall;
	register struct vnode *vp;

	/* It was originally commented out!!! */
	/*
	tmpsyscall = u.u_procp->p_systemcall;
	u.u_procp->p_systemcall = DUUPDATE;
	vp = (struct vnode *) VFSTORFS(vfsp);
	(void)remote_call (vp,NULL);
	u.u_procp->p_systemcall = tmpsyscall;
	if (u.u_error == ENOLINK)
		u.u_error = 0;
	DUPRINT1 (DB_FSS,"rfs_sync called\n");
	*/
	return(0);
}

/*
 * Root of Rfs
 */
int
Rfs_root(vfsp, vpp)
	struct vfs *vfsp;
	struct vnode **vpp;
{

	*vpp = (struct vnode *)((struct rfsmount *)vfsp->vfs_data)->m_rfsvp;
	(*vpp)->v_count++;
	DUPRINT3(DB_FSS,"Rfs_root: vfsp = %x, vp = %x\n", vfsp, *vpp);
	return(0);
}

int
Rfs_mount()
{
	panic("bad RFS op - mount\n");
}

int
Rfs_umount()
{
	/* Don't panic for now */
	printf("bad RFS op - umount\n");
}

int
Rfs_vget()
{
	panic("bad RFS op - vget\n");
}

/*ARGSUSED*/
int
Rfs_statfs (vfsp, sbp)
	register struct vfs *vfsp;
	register struct statfs *sbp;
{
	struct uio auio;
	struct iovec aiov;
	struct sysv_statfs sfsb;

	aiov.iov_base = (caddr_t)&sfsb;
	auio.uio_iov = &aiov;
	auio.uio_iovcnt = 1;
	auio.uio_offset = 0;
	auio.uio_seg = UIOSEG_KERNEL;
	aiov.iov_len = auio.uio_resid = sizeof(struct sysv_statfs);
	remfileop((struct vnode *)(((struct rfsmount *)vfsp->vfs_data)->m_rfsvp), 0, &auio);
	if (u.u_error == 0) {
		sbp->f_type = sfsb.f_fstyp;
		sbp->f_bsize = sfsb.f_bsize;
		sbp->f_blocks = sfsb.f_blocks;
		sbp->f_bfree = sfsb.f_bfree;
		sbp->f_bavail = sfsb.f_bfree;
		sbp->f_files = sfsb.f_files;
		sbp->f_ffree = sfsb.f_ffree;
	}
}

#endif	defined(SYSV) && defined(RFS)
