/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"@(#)kern-port:nudnix/adv.c	10.17"		*/
/*
 *	advertise / unadvertise
 */

#if	defined(SYSV) && defined(RFS)
#include "../h/types.h"
#include "../sysv/sys/sema.h"
#include "../h/param.h"
#include "../h/user.h"
#include "../h/vnode.h"
#include "../h/vfs.h"
#include "../sysv/sys/fs/s5dir.h"
#include "../sysv/sys/comm.h"
#include "../sysv/sys/errno.h"
#include "../sysv/sys/rfsnode.h"
#include "../sysv/sys/mount.h"
#include "../sysv/sys/adv.h"
#include "../sysv/sys/nserve.h"
#include "../sysv/sys/debug.h"
#include "../sysv/sys/rdebug.h"
#include "../sysv/sys/stream.h"
	/***********************
	#include "sys/inline.h"
	#include "sys/signal.h"
	#include "sys/psw.h"
	#include "sys/pcb.h"
	#include "sys/inode.h"
	**********************/


extern	int	bootstate;
extern	int	nadvertise;
char	*addalist();
struct advertise	*getadv();
int	adv_lck =  0;		/* advertise table lock */

/*
 *	Advertise a file system service to the name server.
 *
 */

advfs()
{
	struct	a	{
		char	*fs;		/* root of file system */
		char	*svcnm;		/* global name given to name server */
		int	rwflag;		/* readonly/read write flag	*/
		char	**clist;	/* client list			*/
	} *uap = (struct a *) u.u_ap;
	struct	vnode	*vp;
	struct	advertise	*ap, *a, *findadv();
	rcvd_t	gift;			/* rcvd for advertised resource */

	char	*to, *from, adv_name [NMSZ];	/* temps */
	extern	rcvd_t	cr_rcvd();
	extern  int 	nservers;

	if (bootstate != DU_UP)  {
		u.u_error = ENONET;
		return;
	}

	if(nservers == 0) {
		u.u_error = ENOMEM;
		return;
	}
	if (!suser())
		return;

	/* get the name to be advertised */
	switch (upath(uap->svcnm,adv_name,NMSZ)) {
	case -2:	/* too long	*/
	case  0:	/* too short	*/
		u.u_error = EINVAL;
		return;
	case -1:	/* bad user address	*/
		u.u_error = EFAULT;
		return;
	}

	/*
	 * if this is a modify request, all we need to do is replace
	 * the client list and return.
	 */
	if (uap->rwflag & A_MODIFY) {
		if ((ap = findadv (adv_name)) == NULL) {
			u.u_error = ENODEV;
			return;
		}
		if(ap->a_flags & A_MINTER) {
			u.u_error = ENODEV;
			return;
		}
		/* remalist/addalist   can not go to sleep */
		if (uap->rwflag & A_CLIST) {
			if (ap->a_clist)
				remalist(ap->a_clist);
		
			ap->a_clist = (uap->clist)?addalist(uap->clist):NULL;
		}
		return;
	}

	u.u_error = lookupname(uap->fs, UIOSEG_USER, FOLLOW_LINK,
				(struct vnode **)0, &vp);
	if(u.u_error) return;
	else if(vp == NULL) {
		u.u_error = ENOENT;
		return;
	}

	if (vp->v_type != VDIR)  {
		VN_RELE(vp);
		u.u_error = ENOTDIR;
		return;
	}

	if (vp->v_flag & VADV)  {
		VN_RELE(vp);
		u.u_error = EADV;
		return;
	}


	/* search the advertise table for a free slot */
	for (ap = advertise, a = 0; ap < &advertise[nadvertise]; ap++)
		if (ap->a_flags == A_FREE) {
			if (!a)
				a = ap;
		} else  {
			if (!strcmp(ap->a_name, adv_name)) {
				VN_RELE(vp);
				u.u_error = (ap->a_flags & A_MINTER)?
					ENXIO:EBUSY;
				return;
			}
			if (ap->a_queue->rd_vnode == vp) {
				VN_RELE(vp);
				u.u_error = EEXIST;
				return;
			}
		}
		
	if (!(ap = a)) {
		u.u_error = ENOSPC;
		VN_RELE(vp);
		return;
	}

	ap->a_flags = A_INUSE;

	/*
	 * if file system was mounted read only,
	 * the advertisement must be read only.
	 */
	if((vp->v_vfsp->vfs_flag & VFS_RDONLY) && !(uap->rwflag & A_RDONLY)) {
		VN_RELE(vp);
		u.u_error = EROFS;
		ap->a_flags = A_FREE;
		return;
	}
	if (uap->rwflag & A_RDONLY)
		ap->a_flags |= A_RDONLY;
	/*
	 * now add authorization list, if necessary.
	 */
	if ((uap->rwflag & A_CLIST) && uap->clist != NULL) {
		if ((ap->a_clist=addalist(uap->clist)) == NULL) {
			VN_RELE(vp);
			ap->a_flags = A_FREE;
			return;
		}
	}
	else
		ap->a_clist = NULL;

	/*
	 * allocate queue for advertised object.
	 */
	if ((gift = cr_rcvd (MOUNT_QSIZE, GENERAL)) == NULL) {
			VN_RELE(vp);
			u.u_error = ENOMEM;
			if (ap->a_clist)
				remalist(ap->a_clist);
			ap->a_flags = A_FREE;
			return;
	}
	vp->v_flag |= VADV;
	vp->v_rcvd = gift;	/* add gift to vnode */
	ap->a_count = 0;
	ap->a_queue = gift;
	for (from = adv_name, to = ap->a_name;
		*from != NULL  &&  from < &adv_name[NMSZ];)
			*to++ = *from++;
	*to = NULL;
	gift->rd_max_serv = MOUNT_QSIZE;
	gift->rd_vnode = vp;	/* associate gift with inode */
	DUPRINT2(DB_MNT_ADV,"exit adv: u_error is %d\n",u.u_error);
}

/*
 *	Unadvertise a remotely accessible filesystem.
 */

unadvfs()
{
	struct	a	{
		char	*svcnm;		/* global name given to name server */
	} *uap = (struct a *) u.u_ap;
	struct	vnode	*vp;
	struct	advertise	*ap, *findadv();
	char	adv_name [NMSZ];	/* temp */

	if (bootstate != DU_UP)  {
		u.u_error = ENONET;
		return;
	}

	if (!suser())
		return;

	/* get the name to be unadvertised */
	switch (upath(uap->svcnm,adv_name,NMSZ)) {
	case -2:	/* too long	*/
	case  0:	/* too short	*/
		u.u_error = EINVAL;
		return;
	case -1:	/* bad user address	*/
		u.u_error = EFAULT;
		return;
	}

	if ((ap = findadv (adv_name)) == NULL) {
		u.u_error = ENODEV;
		return;

	}
	if(ap->a_flags & A_MINTER) {
		u.u_error = ENODEV;
		return;
	}
	ap->a_flags |= A_MINTER;

	vp = ap->a_queue->rd_vnode;
	vp->v_flag &= ~VADV;
	del_rcvd (ap->a_queue, (queue_t *)NULL);
	/*
	 * get rid of auth list regardless of whether entry goes
	 * away now or later.
	 */
	if (ap->a_clist) {
		remalist(ap->a_clist);
		ap->a_clist = NULL;
	}
	if (ap->a_count <= 0) {
		ap->a_flags = A_FREE;
		VN_RELE(vp);	/* advertise did the nami(lookup)/iget */
	}
}

/*  Advertise table lookup using inode pointer as the key.
 */

struct	advertise *
getadv (vp)
struct	vnode	*vp;
{
	register	struct	advertise	*ap;
	
	for (ap = advertise; ap < &advertise[nadvertise]; ap++)
		if (ap->a_flags & A_INUSE)
		if (ap->a_queue->rd_vnode == vp)
			return (ap);
	return (NULL);
}

/* Advertise table lookup using a_name as the key.
 */

struct advertise *
findadv(name)
char	*name;
{
	register struct advertise	*ap;

	for (ap=advertise; ap < &advertise[nadvertise]; ap++)
		if ((ap->a_flags & A_INUSE) &&
		    (strcmp(name,ap->a_name) == NULL))
			return(ap);
	return(NULL);
}
#endif	defined(SYSV) && defined(RFS)
