/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
#ident	"@(#)kern-port:io/tt1.c	10.4"

/*
 * Line discipline 0
 * No Virtual Terminal Handling
 */

#include "../h/types.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/user.h"
#include "../h/errno.h"
#include "../h/proc.h"
#include "../h/tty.h"
#include "../h/file.h"
#include "../h/kernel.h"
#include "../sysv/sys/termio.h"
#include "../h/conf.h"

#define	CHAR_XPUT(tp, c) \
			while (sv_ttxput((tp), (c), 0)) { \
				(*tp->svt_proc)((tp), T_OUTPUT); \
				sleep((caddr_t)&lbolt, TTOPRI); \
			}
extern char sv_partab[];

/*
 * routine called on first teletype open.
 * establishes a process group for distribution
 * of quits and interrupts from the tty.
 */
sv_ttopen(dev, tp, flag)
dev_t dev;
register struct tty *tp;
int flag;
{
	register struct proc *pp;

	pp = u.u_procp;
	tp->t_universe = pp->p_universe;   	/* ISI: set tty universe */
	tp->t_dev = dev;
	if (pp->p_pgrp == 0) {		/* use 4.3 process group approach */
		u.u_ttyp = tp;
		u.u_ttyd = dev;
		if (tp->t_pgrp == 0)
			tp->t_pgrp = pp->p_pid;
		pp->p_pgrp = tp->t_pgrp;
	}
	else if (pp->p_pid == pp->p_pgrp && u.u_ttyp == NULL
							&& tp->t_pgrp == 0) {
		u.u_ttyp = tp;
		tp->t_pgrp = pp->p_pgrp;
	}
	sv_ttioctl(tp, LDOPEN, 0);
	tp->svt_state &= ~WOPEN;
	tp->svt_state |= ISOPEN;
	if (flag & FNDELAY)
		tp->svt_state |= NBIO;
	else
		tp->svt_state &= ~NBIO;
	map_tty(tp, TO43);
	return 0;
}

/*
 * line close routine
 * in keeping with 4.3 tty device close conventions
 */
sv_ttlclose(tp)
register struct tty *tp;
{
	if ((tp->svt_state&ISOPEN) == 0)
		return;
	tp->t_universe = u.u_procp->p_universe;	/* ISI: set tty universe */
	sv_ttioctl(tp, LDCLOSE, 0);
}

/*
 * tty close routine (simply clear out state)
 */
sv_ttyclose(tp)
register struct tty *tp;
{
	sv_ttyflush(tp, (FREAD|FWRITE));
	tp->t_pgrp = 0;
	tp->svt_state = 0;
	map_state(tp, TO43);
}

/*
 * Called from device's read routine after it has
 * calculated the tty-structure given as argument.
 */
sv_ttread(tp, uio)
register struct tty *tp;
struct uio *uio;
{
	register struct clist *tq;
	register int c;
	register int error = 0;

	tp->t_universe = u.u_procp->p_universe;	/* ISI: set tty universe */
	tq = &tp->t_canq;

	if (tq->c_cc == 0)
		sv_canon(tp);
	while (uio->uio_resid && error == 0 && ((c = getc(tq)) >= 0))
 		error = ureadc(c, uio);
	if (tp->svt_state&TBLOCK) {
		if (tp->t_rawq.c_cc<TTXOLO) {
			(*tp->svt_proc)(tp, T_UNBLOCK);
		}
	}
	return error;
}

/*
 * Called from device's write routine after it has
 * calculated the tty-structure given as argument.
 */
sv_ttwrite(tp, uio)
register struct tty *tp;
struct uio *uio;
{
	register int oldpri;
	register int error= 0;
	register int cc;
	char obuf[OBUFSIZ];

	if (!(tp->svt_state&CARR_ON))
		return error;
	tp->t_universe = u.u_procp->p_universe;	/* ISI: set tty universe */
	while (uio->uio_resid > 0) {
		if (tp->t_outq.c_cc > (int)tthiwat[tp->svt_cflag&SV_CBAUD]) {
			oldpri = spltty();
			while (tp->t_outq.c_cc > (int)tthiwat[tp->svt_cflag&SV_CBAUD]){
				(*tp->svt_proc)(tp, T_OUTPUT);
				tp->svt_state |= OASLP;
				map_state(tp, TO43);
				sleep((caddr_t)&tp->t_outq, TTOPRI);
			}
			splx(oldpri);
		}

		cc = uio->uio_iov->iov_len;
		if (cc == 0) {
			uio->uio_iovcnt--;
			uio->uio_iov++;
			if (uio->uio_iovcnt <= 0)
				panic("ttwrite");
			continue;
		}
		if (cc > OBUFSIZ)
			cc = OBUFSIZ;
		error = uiomove(obuf, cc, UIO_WRITE, uio);
		if (error)
			break;
		if (cc = sv_ttxput(tp, obuf, cc)) {
			if (!(tp->svt_proc))
				panic("sv_ttwrite: no output proc");
			(*tp->svt_proc)(tp, T_OUTPUT);
			sleep((caddr_t)&lbolt, TTOPRI);
			uio->uio_iov->iov_base -= cc;
			uio->uio_iov->iov_len += cc;
			uio->uio_resid += cc;
			uio->uio_offset -= cc;
		}
	}
	oldpri = spltty();
	(*tp->svt_proc)(tp, T_OUTPUT);
	splx(oldpri);
	return error;
}

/*
 * Place a character on raw TTY input queue, putting in delimiters
 * and waking up top half as needed.
 * Also echo if required.
 */
sv_ttin(c, tp, code)
register int c;
register struct tty *tp;
{
	register flg;

	if (code == L_BREAK) {
		gsignal(tp->t_pgrp, SIGINT);
		sv_ttyflush(tp, (FREAD|FWRITE));
		return;
	}
	c &= 0377;				/* as in 4.3 */
	flg = tp->svt_iflag;
					/* KMC does all but IXOFF */
	if (tp->svt_state&EXTPROC)
		flg &= SV_IXOFF;

	if (tp->svt_iflag & SV_IXON) { 		/* handle START/STOP */

		register int ctmp;
		if (tp->svt_state & SV_ISTRIP)
			ctmp = c & 0177;
		else
			ctmp = c;
		if (tp->svt_state & TTSTOP) {
			if (ctmp == CSTART || tp->svt_iflag & SV_IXANY)
				(*tp->svt_proc)(tp, T_RESUME);
		} else {
			if (ctmp == CSTOP)
				(*tp->svt_proc)(tp, T_SUSPEND);
		}
		if (ctmp == CSTART || ctmp == CSTOP)
			return;
	}

	        /* Check for errors */
	if (c == '\n' && flg&SV_INLCR)
		c = '\r';
	else if (c == '\r')
		if (flg&SV_IGNCR)
			goto out;	
		else if (flg&SV_ICRNL)
			c = '\n';
	if (flg&SV_IUCLC && 'A' <= c && c <= 'Z')
		c += 'a' - 'A';
	if (putc(c, &tp->t_rawq))
		goto out;

	if (tp->t_rawq.c_cc > TTXOHI) {
		if (flg&SV_IXOFF && !(tp->svt_state&TBLOCK))
			(*tp->svt_proc)(tp, T_BLOCK);
		if (tp->t_rawq.c_cc > TTYHOG) {
			sv_ttyflush(tp, FREAD);
			return;
		}
	}
	flg = lobyte(tp->svt_lflag);
	if (flg&SV_ISIG) {
		if (c == tp->svt_cc[VINTR]) {
			gsignal(tp->t_pgrp, SIGINT);
			if (!(flg&SV_NOFLSH))
				sv_ttyflush(tp, (FREAD|FWRITE));
			goto out;
		}
		if (c == tp->svt_cc[VQUIT]) {
			gsignal(tp->t_pgrp, SIGQUIT);
			if (!(flg&SV_NOFLSH))
				sv_ttyflush(tp, (FREAD|FWRITE));
			goto out;
		}
		if (c == tp->svt_cc[VSWTCH]) {
			if (!(flg&SV_NOFLSH))
				sv_ttyflush(tp, (FREAD|FWRITE));
			(*tp->svt_proc)(tp, T_SWTCH);
			goto out;
		}
	}
	if (flg&SV_ICANON) {
		if (c == '\n') {
			if (flg&SV_ECHONL)
				flg |= SV_ECHO;
			tp->svt_delct++;
#ifdef is68k
			/*
			 * For BSD's select system call which is now
			 * availble on isi's Dual-Port System V
			 */
			ttwakeup(tp);
#endif
		} else if (c == tp->svt_cc[VEOL] || c == tp->svt_cc[VEOL2]) {
			tp->svt_delct++;
#ifdef is68k
			/*
			 * For BSD's select system call which is now
			 * availble on isi's Dual-Port System V
			 */
			ttwakeup(tp);
#endif
		}
		if (!(tp->svt_state&CLESC)) {
			if (c == '\\')
				tp->svt_state |= CLESC;
			if (c == tp->svt_cc[VERASE] && flg&SV_ECHOE) {
				if (flg&SV_ECHO)
					CHAR_XPUT(tp, '\b');
				flg |= SV_ECHO;
				CHAR_XPUT(tp, ' ');
				c = '\b';
			} else if (c == tp->svt_cc[VKILL] && flg&SV_ECHOK) {
				if (flg&SV_ECHO)
					CHAR_XPUT(tp, c);
				flg |= SV_ECHO;
				c = '\n';
			} else if (c == tp->svt_cc[VEOF]) {
				flg &= ~SV_ECHO;
				tp->svt_delct++;
			}
		} else {
			if (c != '\\' || (flg&SV_XCASE))
				tp->svt_state &= ~CLESC;
		}
	}
	if (flg&SV_ECHO) {
		CHAR_XPUT(tp, c);
		(*tp->svt_proc)(tp, T_OUTPUT);
	}
out:
	if (!(flg&SV_ICANON)) {
#ifdef is68k
		/*
		 * For BSD's select system call which is now
		 * availble on isi's Dual-Port System V
		 */
		ttwakeup(tp);
#endif
		tp->svt_state &= ~RTO;
		if (tp->t_rawq.c_cc >= tp->svt_cc[VMIN])
			tp->svt_delct = 1;
		else if (tp->svt_cc[VTIME]) {
			if (!(tp->svt_state&TACT))
				sv_tttimeo(tp);
		}
	}
	wakeup((caddr_t)&tp->t_rawq);
}

/*
 *	line switch output routine: always return TRUE
 */
sv_ttout(tp)
register struct tty *tp;
{
	return 1;
}

/*
 * Put character(s) on TTY output queue, adding delays,
 * expanding tabs, and handling the CR/NL bit.
 * It is called both from the base level for output, and from
 * interrupt level for echoing.
 */
sv_ttxput(tp, ucp, ncode)
register struct tty *tp;
union {
	int ch;
	u_char *ptr;
} ucp;
{
	register int c;
	register int flg;
	register u_char *cp;
	register char *colp;
	int ctype;
	int cs;

	if (tp->svt_state&EXTPROC) {
		if (tp->svt_lflag&SV_XCASE)
			flg = SV_OPOST;
		else
			flg = 0;
	} else
		flg = tp->svt_oflag;
	if (ncode == 0) {
		ncode++;
		cp = (unsigned char *)&ucp.ch + 3; 
			/* char is in least significant byte of first param */
		if (!(flg&SV_OPOST)) {
			c = *cp;
			putc(c, &tp->t_outq);
			return 0;
		}
	} else {
		cp = ucp.ptr;
		if (!(flg&SV_OPOST))
			return b_to_q(cp, ncode, &tp->t_outq);
	}
	while (ncode) {
		register int ordinaries, resid;

		if (!(tp->svt_lflag&SV_XCASE)) {
					/* get first N ordinary chars */
			ordinaries = ncode - scanc((unsigned)ncode, (caddr_t)cp,
						(caddr_t)sv_partab, 077);
			if (ordinaries != 0) {
				if (resid = b_to_q(cp, ordinaries, &tp->t_outq))
					return resid;	/* out of clists */
				ncode -= ordinaries;
				cp += ordinaries;
				continue;
			}
		}
					/* special, do on a per char baisis */
		c = *cp++;
		if (c >= 0200 && !(tp->svt_state&EXTPROC)) {
			(void) putc(c, &tp->t_outq);
			goto out;
		}
		/*
		 * Generate escapes for upper-case-only terminals.
		 */
		if (tp->svt_lflag&SV_XCASE) {
			colp = "({)}!|^~'`\\\0";
			while (*colp++)
				if (c == *colp++) {
					CHAR_XPUT(tp, '\\');
					c = colp[-2];
					break;
				}
			if ('A' <= c && c <= 'Z')
				CHAR_XPUT(tp, '\\');
		}
		if (flg&SV_OLCUC && 'a' <= c && c <= 'z')
			c += 'A' - 'a';

		cs = c;
		/*
		 * Calculate delays.
		 * The numbers here represent clock ticks
		 * and are not necessarily optimal for all terminals.
		 * The delays are indicated by characters above 0200.
		 */
		ctype = sv_partab[c];
		colp = &tp->svt_col;
		c = 0;
		switch (ctype&077) {

		case 0:	/* ordinary */
			(*colp)++;

		case 1:	/* non-printing */
			break;

		case 2:	/* backspace */
			if (flg&SV_BSDLY)
				c = 2;
			if (*colp)
				(*colp)--;
			break;

		case 3:	/* line feed */
			if (flg&SV_ONLRET)
				goto cr;
			if (flg&SV_ONLCR) {
				if (!(flg&SV_ONOCR && *colp==0)) {
					putc('\r', &tp->t_outq);
				}
				goto cr;
			}
		nl:
			if (flg&SV_NLDLY)
				c = 5;
			break;

		case 4:	/* tab */
			c = 8 - ((*colp)&07);
			*colp += c;
			ctype = flg&SV_TABDLY;
			if (ctype == SV_TAB0) {
				c = 0;
			} else if (ctype == SV_TAB1) {
				if (c < 5)
					c = 0;
			} else if (ctype == SV_TAB2) {
				c = 2;
			} else if (ctype == SV_TAB3) {
				do
					putc(' ', &tp->t_outq);
				while (--c);
				goto out;
			}
			break;

		case 5:	/* vertical tab */
			if (flg&SV_VTDLY)
				c = 0177;
			break;

		case 6:	/* carriage return */
			if (flg&SV_OCRNL) {
				cs = '\n';
				goto nl;
			}
			if (flg&SV_ONOCR && *colp == 0)
				goto out;
		cr:
			ctype = flg&SV_CRDLY;
			if (ctype == SV_CR1) {
				if (*colp)
					c = MAX((*colp>>4) + 3, 6);
			} else if (ctype == SV_CR2) {
				c = 5;
			} else if (ctype == SV_CR3) {
				c = 9;
			}
			*colp = 0;
			break;

		case 7:	/* form feed */
			if (flg&SV_FFDLY)
				c = 0177;
			break;
		}
		putc(cs, &tp->t_outq);
		if (c) {
			if ((c < 32) && flg&SV_OFILL) {
				if (flg&SV_OFDEL)
					cs = 0177;
				else
					cs = 0;
				putc(cs, &tp->t_outq);
				if (c > 3)
					putc(cs, &tp->t_outq);
			} else {
				putc(c|0200, &tp->t_outq);
			}
		}
out:	ncode--;
	}
	return 0;
}

sv_tttimeo(tp)
register struct tty *tp;
{
	tp->svt_state &= ~TACT;
	if (tp->svt_lflag&SV_ICANON || tp->svt_cc[VTIME] == 0)
		return;
	if (tp->t_rawq.c_cc == 0 && tp->svt_cc[VMIN])
		return;
	if (tp->svt_state&RTO) {
		tp->svt_delct = 1;
		wakeup((caddr_t)&tp->t_rawq);
	} else {
		tp->svt_state |= RTO|TACT;
		timeout(sv_tttimeo, tp, tp->svt_cc[VTIME]*(hz/10));
	}
}

/*
 * I/O control interface
 */
sv_ttioctl(tp, cmd, arg)
register struct tty *tp;
{
	ushort	chg;
	register int	oldpri;

	tp->t_universe = u.u_procp->p_universe;	/* ISI: set tty universe */
	switch (cmd) {
	case LDOPEN:
		(*tp->svt_proc)(tp, T_INPUT);
		break;

	case LDCLOSE:
		oldpri = spltty();
		(*tp->svt_proc)(tp, T_RESUME);
		splx(oldpri);
		sv_ttywait(tp);
		sv_ttyflush(tp, FREAD);
		break;

	case LDCHG:
		chg = tp->svt_lflag^arg;
		if (!(chg&SV_ICANON))
			break;
		oldpri = spltty();
		if (tp->t_canq.c_cc) {
			if (tp->t_rawq.c_cc) {
				tp->t_canq.c_cc += tp->t_rawq.c_cc;
			}
			tp->t_rawq = tp->t_canq;
			tp->t_canq = ttnulq;
		}
		tp->svt_delct = tp->t_rawq.c_cc;
		splx(oldpri);
		break;

	default:
		break;
	}
}

/*
 * Handle modem control transition on a tty.
 * Flag indicates new state of carrier.
 * Returns 0 if the line should be turned off, otherwise 1.
 */
sv_ttmodem(tp, flag)
	register struct tty *tp;
{
	if ((tp->svt_state & WOPEN) == 0 && (tp->svt_cflag & SV_CLOCAL)) {
		if (flag) {
			tp->svt_state &= ~TTSTOP;
			map_state(tp, TO43);
			(*tp->svt_proc)(tp, T_OUTPUT);
		} else if ((tp->svt_state & TTSTOP) == 0) {
			tp->svt_state |= TTSTOP;
			map_state(tp, TO43);
			(*cdevsw[major(tp->t_dev)].d_stop)(tp, 0);
		}
	} else if (flag == 0) {
		/*
		 * Lost carrier.
		 */
	    	if (tp->svt_cflag & SV_CLOCAL)		/* ignore */
			return (1);
		tp->svt_state &= ~CARR_ON;
		map_state(tp, TO43);
		if (tp->svt_state & ISOPEN) {
			gsignal(tp->t_pgrp, SIGHUP);
			gsignal(tp->t_pgrp, SIGCONT);
			sv_ttyflush(tp, FREAD|FWRITE);
			return (0);
		}
	} else {
		/*
		 * Carrier now on.
		 */
		tp->svt_state |= CARR_ON;
		map_state(tp, TO43);
		wakeup((caddr_t)&tp->t_rawq);
	}
	return (1);
}
