#ifdef	SYSV
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
#ident	"@(#)kern-port:io/shm.c	10.10"
*/

#include "../h/types.h"
#include "../machine/pte.h"
#include "param.h"
#include "systm.h"
#include "map.h"
#include "user.h"
#include "proc.h"
#include "text.h"
#include "buf.h"
#include "seg.h"
#include "vm.h"
#include "../sysv/sys/filehdr.h"
#include "../sysv/sys/region.h"
#include "../sysv/sys/ipc.h"
#include "../sysv/sys/shm.h"
#include "../machine/board.h"

struct shmid_ds	*shmem;		/* shared memory headers */
struct shminfo	shminfo;		/* shared memory info structure */
extern	time_t		time;		/* system idea of date */
int	shmcreated;	/* number of shared memory segments in existence */

struct	shmid_ds	*ipcget(),
			*shmconv();


/*
 * Shmat (attach shared segment) system call.
 */
shmat()
{
	register struct a {
		int	shmid;
		uint	addr;
		int	flag;
	}	*uap = (struct a *)u.u_ap;
	register struct shmid_ds	*sp;
	register struct text		*rp;
	register struct pregion		*prp;

	if ((sp = shmconv(uap->shmid)) == NULL)
		return;
	if (ipcaccess(&sp->shm_perm, SHM_R))
		return;
	if ((uap->flag & SHM_RDONLY) == 0)
		if (ipcaccess(&sp->shm_perm, SHM_W))
			return;
	if (u.u_nshmseg >= shminfo.shmseg) {
		u.u_error = EMFILE;
		return;
	}
	if (u.u_procp->p_region == NULL) {
		if ((u.u_procp->p_region = preg_alloc()) == NULL) {
			return;
		}
	}
	rp = sp->shm_reg;
	xlock(rp);
	if (uap->addr == 0)
		uap->addr = shmaddr();
	else if (uap->flag & SHM_RND)
		uap->addr = uap->addr & ~(SHMLBA - 1);
	
/*
	if (rp->x_size  &&  preg_chksize() < 0) {
		xunlock(rp);
		u.u_error = ENOMEM;
		return;
	}
*/

	if ((prp = preg_attachreg(&u, rp, uap->addr, PT_SHMEM,
	   uap->flag & SHM_RDONLY, rp->x_size)) == NULL) {
		xunlock(rp);
		return;
	}
	xunlock(rp);
	if (preg_xattach(prp, NULL, NULL, sp->shm_perm.mode & SHM_INIT) == 0) {
		preg_delete(prp, rp->x_size);
		u.u_error = ENOMEM;
		return;
	}
	sp->shm_perm.mode &= ~SHM_INIT;
	u.u_r.r_val1 = (int) prp->p_regva;
	u.u_nshmseg++;
	sp->shm_atime = time;
	sp->shm_lpid = u.u_procp->p_pid;
}

/*
 * Convert user supplied shmid into a ptr to the associated
 * shared memory header.
 */
struct shmid_ds *
shmconv(s)
register int	s;	/* shmid */
{
	register struct shmid_ds	*sp;	/* ptr to associated header */

	if (s < 0)
	{
		u.u_error = EINVAL;
		return(NULL);
	}
	sp = &shmem[s % shminfo.shmmni];
	if (!(sp->shm_perm.mode & IPC_ALLOC)  
		|| s / shminfo.shmmni != sp->shm_perm.seq) {
		u.u_error = EINVAL;
		return(NULL);
	}
	return(sp);
}

/*
 * Shmctl system call.
 */
shmctl()
{
	register struct a {
		int		shmid,
				cmd;
		struct shmid_ds	*arg;
	}	*uap = (struct a *)u.u_ap;
	register struct shmid_ds	*sp;	/* shared memory header ptr */
	struct shmid_ds_52		sp_52;	/* for 5.2 binaries */
	register struct text		*rp;	/* shmem region */
	struct shmid_ds			ds;	/* hold area for IPC_SET */

	if ((sp = shmconv(uap->shmid)) == NULL)
		return;

	switch (uap->cmd) {

	/* Remove shared memory identifier. */
	case IPC_RMID:
		if (u.u_uid != sp->shm_perm.uid && u.u_uid != sp->shm_perm.cuid
			&& !suser())
			return;
		rp = sp->shm_reg;
		if (rp->x_count == 0)
			preg_freeshmem(rp, sp->shm_perm.mode & SHM_INIT);
		else
			rp->x_flag &= ~XNOFREE;
		sp->shm_reg = NULL;
		sp->shm_perm.mode = 0;
		sp->shm_segsz = 0;
		if (((int)(++(sp->shm_perm.seq) * shminfo.shmmni + (sp - shmem))) < 0)
			sp->shm_perm.seq = 0;
		shmcreated--;
		break;

	/* Set ownership and permissions. */
	case IPC_SET:
		if (u.u_uid != sp->shm_perm.uid && u.u_uid != sp->shm_perm.cuid
			 && !suser())
			 return;
		if (u.u_filemagic == NCRMAGIC) {
			if (copyin (uap->arg, &sp_52, sizeof (sp_52))) {
				u.u_error = EFAULT;
				return;
			}
			shmconv_from_52 (&sp_52, &ds);
		}
		else
		  	if (copyin(uap->arg, &ds, sizeof(ds))) {
				u.u_error = EFAULT;
				return;
			}
		sp->shm_perm.uid = ds.shm_perm.uid;
		sp->shm_perm.gid = ds.shm_perm.gid;
		sp->shm_perm.mode = (ds.shm_perm.mode & 0777) |
			(sp->shm_perm.mode & ~0777);
		sp->shm_ctime = time;
		break;

	/* Get shared memory data structure. */
	case IPC_STAT:
		if (ipcaccess(&sp->shm_perm, SHM_R))
			return;

		/*	The following is needed because
		**	a user can look at it.  In
		**	particular, the regression tests
		**	require it.
		*/

		sp->shm_nattch = sp->shm_reg->x_count;
		sp->shm_cnattch = sp->shm_nattch;

		/*
		 * Currently NCR binaries are built on 5.2 systems.  This
		 * means the the shmid_ds structures are a different size.
		 */
		if (u.u_filemagic == NCRMAGIC) {
			shmconv_to_52 (sp, &sp_52);
			if (copyout(&sp_52, uap->arg, sizeof (sp_52)))
			  	u.u_error = EFAULT;
		}
		else
			if (copyout(sp, uap->arg, sizeof(*sp)))
				u.u_error = EFAULT;
		break;

	/* Lock segment in memory */
	case SHM_LOCK:
		if (!suser())
			return;

		rp = sp->shm_reg;
		xlock(rp);
		if (rp->x_noswapcnt == 0) {
			if (freemem - rp->x_size < desfree) {
				xunlock(rp);
				u.u_error = ENOMEM;
				return;
			}
		}
		++rp->x_noswapcnt;
		xunlock(rp);
		break;

	/* Unlock segment */
	case SHM_UNLOCK:
		if (!suser())
			return;

		rp = sp->shm_reg;
		xlock(rp);
		if (rp->x_noswapcnt == 0) {
			/*	User didn't really lock it.
			*/

			xunlock(rp);
			break;
		}
		--rp->x_noswapcnt;
		xunlock(rp);
		break;

	default:
		u.u_error = EINVAL;
	}
}

/*
 * Detach shared memory segment
 */
shmdt()
{
	register struct a {
		caddr_t	addr;
	} *uap = (struct a *)u.u_ap;
	register struct pregion	*prp;
	register struct text	*rp;
	register struct shmid_ds *sp;
	register short	sz;
	caddr_t		regva;

	/*
	 * Find matching shmem address in process region list
	 */

	for (prp = u.u_procp->p_region; prp->p_ps; prp++)
		if (prp->p_type == PT_SHMEM && prp->p_regva == uap->addr)
			break;
	if (prp->p_ps == NULL) {
		u.u_error = EINVAL;
		return;
	}

	/*
	 * Detach region from process
	 * We must remember rp here since detach clobbers p_reg
	 */

	regva = prp->p_regva;
	rp = prp->p_ps;
	sz = rp->x_size;
	preg_xfree(prp);
	preg_delete(prp, sz);
	u.u_nshmseg--;

	/*
	 * Find shmem region in system wide table.  Update detach time
	 * and pid, and free if appropriate
	 */
	for (sp = shmem; sp < &shmem[shminfo.shmmni]; sp++)
		if (sp->shm_reg == rp)
			break;
	if (sp >= &shmem[shminfo.shmmni])
		return;	/* shmem has been removed already */
	sp->shm_dtime = time;
	sp->shm_lpid = u.u_procp->p_pid;
}

/*
 * Shmget (create new shmem) system call.
 */
shmget()
{
	register struct a {
		key_t	key;
		uint	size,
			shmflg;
	}	*uap = (struct a *)u.u_ap;
	register struct shmid_ds	*sp;	/* shared memory header ptr */
	register struct text		*rp;	/* shared memory region ptr */
	int				s;	/* ipcget status */
	extern struct text *preg_xalloc();

	sp = ipcget(uap->key, uap->shmflg,  shmem, shminfo.shmmni,
		    sizeof(*sp), &s);
	if (sp == NULL)
		return;
	if (s) {
		if (shmcreated + 1 > shmmni) {
			u.u_error = ENOSPC;
			return;
		}
		/*
		 * This is a new shared memory segment.
		 * Allocate a region and init shmem table
		 */
		if (uap->size < shminfo.shmmin || uap->size > shminfo.shmmax) {
			u.u_error = EINVAL;
			sp->shm_perm.mode = 0;
			return;
		}
		if ((rp = preg_xalloc(NULL)) == NULL) {
			u.u_error = EAGAIN;
			sp->shm_perm.mode = 0;
			return;
		}
		sp->shm_perm.mode |= SHM_INIT;	/* grow on first attach */
		rp->x_size = clrnd(btoc(uap->size));
		sp->shm_segsz = ctob(rp->x_size);
		sp->shm_reg = rp;
		sp->shm_atime = sp->shm_dtime = 0;
		sp->shm_ctime = time;
		sp->shm_lpid = 0;
		sp->shm_cpid = u.u_procp->p_pid;
		rp->x_flag |= XNOFREE;
		shmcreated++;
	} else {
		/*
		 * Found an existing segment.  Check size
		 */
		if (uap->size && uap->size > sp->shm_segsz) {
			u.u_error = EINVAL;
			return;
		}
	}

	u.u_r.r_val1 = sp->shm_perm.seq * shminfo.shmmni + (sp - shmem);
}

/*
 * System entry point for shmat, shmctl, shmdt, and shmget system calls.
 */

int	(*shmcalls[])() = {shmat, shmctl, shmdt, shmget};

shmsys()
{
	register struct a {
		uint	id;
	}	*uap = (struct a *)u.u_ap;
	int		shmat(),
			shmctl(),
			shmdt(),
			shmget();

	if (uap->id > 3) {
		u.u_error = EINVAL;
		return;
	}
	u.u_ap = &u.u_arg[1];
	(*shmcalls[uap->id])();
}

/*
 * Select attach address based on segment size
 */

shmaddr()
{
	register uint	vaddr;
	register uint	vaddrt;
	register preg_t	*prp;

	vaddr = ctob(stoc(ctos(u.u_dsize + 
			stoc(ctos(u.u_tsize + u.u_procp->p_tstart)))));

	if ((prp = u.u_procp->p_region)) {
		for (prp = u.u_procp->p_region ; prp->p_ps ; prp++) {
			if (prp->p_type == PT_LIBDAT)
				vaddrt = (uint)(prp->p_regva +
						ctob(prp->p_pp->r_pgsz));
			else
				vaddrt = (uint)(prp->p_regva +
						ctob(prp->p_ps->x_size));
			if (vaddr < vaddrt)
				vaddr = vaddrt;
		}
	}
	vaddr = (vaddr + SOFFMASK) & ~SOFFMASK;
	return(vaddr);
}

/*
 * Convert 5.3 shmid_ds to 5.2 shmid_ds
 */
shmconv_to_52 (from, to)
	struct shmid_ds *from;
	struct shmid_ds_52 *to;
{
	to->shm_perm = from->shm_perm;
	to->shm_segsz = from->shm_segsz;
	to->shm_lpid = from->shm_lpid;
	to->shm_cpid = from->shm_cpid;
	to->shm_nattch = from->shm_nattch;
	to->shm_cnattch = from->shm_cnattch;
	to->shm_atime = from->shm_atime;
	to->shm_dtime = from->shm_dtime;
	to->shm_ctime	 = from->shm_ctime;
}

shmconv_from_52 (from, to)
	struct shmid_ds_52 *from;
	struct shmid_ds *to;
{
	to->shm_perm = from->shm_perm;
	to->shm_segsz = from->shm_segsz;
	to->shm_lpid = from->shm_lpid;
	to->shm_cpid = from->shm_cpid;
	to->shm_nattch = from->shm_nattch;
	to->shm_cnattch = from->shm_cnattch;
	to->shm_atime = from->shm_atime;
	to->shm_dtime = from->shm_dtime;
	to->shm_ctime	 = from->shm_ctime;
}
 
#endif	SYSV
