#ifdef	SYSV
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
#ident	"@(#)kern-port:io/clone.c	10.5"
/*
 * Clone Driver.
 */


#include "../h/types.h"

#include "../h/param.h"
#include "../h/user.h"
#include "../h/vnode.h"
#include "../h/file.h"
#include "../h/conf.h"
#include "../specfs/snode.h"
#include "../sysv/sys/stropts.h"
#include "../sysv/sys/stream.h"
#include "../h/errno.h"
#include "../h/systm.h"
#include "../sysv/sys/debug.h"

int clnopen();
static struct module_info clnm_info = { 0, "CLONE", 0, 0, 0, 0 };
static struct qinit clnrinit = { NULL, NULL, clnopen, NULL, NULL, &clnm_info, NULL };
static struct qinit clnwinit = { NULL, NULL, NULL, NULL, NULL, &clnm_info, NULL };
struct streamtab clninfo = { &clnrinit, &clnwinit };

/*
 * Clone open.  Dev is the major device of the streams device to
 * open.  Look up the device in the cdevsw[].   Attach its qinit
 * structures to the read and write queues and call its open
 * with the q and the dev CLONEOPEN.  Swap in a new inode with
 * the real device number constructed from the major and the
 * minor returned by the device open.  
 */

clnopen(q, dev, flag, sflag, newdevp)
queue_t *q;
dev_t dev;
int flag;
int sflag;
dev_t *newdevp;
{
	register dev_t i, mindev, newdev;
	register struct streamtab *st;
	register struct vnode *vp, *nvp;
	register struct snode *sp, *nsp;

	if (sflag) return(OPENFAIL);

	/*
	 * Get the device to open.
	 */
	i = minor(dev);
	if ((i >= nchrdev) || !(st = (struct streamtab *)cdevsw[i].d_str)) {
		u.u_error = ENXIO;
		return(OPENFAIL);
	}

	/*
	 * Substitute the real qinit values for the current ones
	 */
	setq(q, st->st_rdinit, st->st_wrinit);

	/*
	 * Call the device open with the stream flag  CLONEOPEN.  The device
	 * will either fail this or return a minor device number.
	 */
	newdev = makedev((minor(dev)&0x7f), 0);
	if ((mindev = (*q->q_qinfo->qi_qopen)(q, newdev, flag, CLONEOPEN))
								== OPENFAIL)
		return(OPENFAIL);

	/*
	 * Get the snode at top of this stream, allocate a new snode,
	 * and exchange the new snode for the old one.
	 */
	newdev = makedev(minor(dev)&0x7f, mindev);
	vp = ((struct stdata *)(q->q_next->q_ptr))->sd_vnode;
	ASSERT(vp);
	sp = VTOS(vp);


	/*
	 * get new vnode for newdev
	 */
	if ((nvp = specvp(vp, newdev)) == (struct vnode *)0) {
		(*q->q_qinfo->qi_qclose)(q, flag);
		return(OPENFAIL);
	}
	nsp = VTOS(nvp);
	nsp->s_sptr = sp->s_sptr;
	nsp->s_sptr->sd_vnode = nvp;
	nsp->s_sptr->sd_strtab = st;

	/* 
	 * disassociate old snode from this stream
	 */
	sp->s_sptr = (struct stdata *) 0;

	if (newdevp != (dev_t *)0)
		*newdevp = newdev;

	return mindev;
}
#endif	SYSV
