#ifdef	SYSV
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"@(#)kern-port:fs/s5/s5sys3.c	10.15"	*/
	/********* Waiting to be included
	#include "sys/types.h"
	#include "sys/sysmacros.h"
	#include "sys/param.h"
	#include "sys/fstyp.h"
	#include "sys/fs/s5macros.h"
	#include "sys/systm.h"
	#include "sys/mount.h"
	#include "sys/ino.h"
	#include "sys/buf.h"
	#include "sys/iobuf.h"
	#include "sys/fs/s5filsys.h"
	#include "sys/fs/s5dir.h"
	#include "sys/errno.h"
	#include "sys/signal.h"
	#include "sys/sbd.h"
	#include "sys/immu.h"
	#include "sys/cmn_err.h"
	#include "sys/psw.h"
	#include "sys/pcb.h"
	#include "sys/user.h"
	#include "sys/fs/s5inode.h"
	#include "sys/inode.h"
	#include "sys/file.h"
	#include "sys/fcntl.h"
	#include "sys/flock.h"
	#include "sys/conf.h"
	#include "sys/stat.h"
	#include "sys/ioctl.h"
	#include "sys/var.h"
	#include "sys/ttold.h"
	#include "sys/open.h"
	#include "sys/debug.h"
	** Waiting to be included ******/

#include "../h/types.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/buf.h"
#include "../h/pathname.h"
#include "../h/vfs.h"
#include "../h/vnode.h"
#include "../h/file.h"
#include "../h/uio.h"
#include "../h/conf.h"
#include "../ufs/fs.h"
#include "../ufs/mount.h"
#include "../ufs/inode.h"
#undef NFS
#include "../h/mount.h"

#include "../sysv/sys/statfs.h"
/*
 * Note that this takes vnode pointer as arg rather than vfs pointer!
 */
int
ufs_s5statfs(vp, sp, ufstyp)
register struct vnode *vp;
register struct sysv_statfs *sp;
int  ufstyp;
{
	struct buf *tp = 0;
	struct vnode *dev_vp;
	dev_t dev;
	register struct fs *fsp;
	int	error = 0;

	if (ufstyp) {
		/*
		 * File system not mounted.  The vnode pointer
		 * refers to a device from which the superblock
		 * must be read.
		 */
		if (vp->v_type != VBLK) {
			return (EINVAL);
		}
		dev = vp->v_rdev;
		if (major(dev) >= nblkdev) {
			return (ENXIO);
		}
		/*
		 * Open block device mounted on.
		 * When bio is fixed for vnodes this can all be vnode operations
		 */
		error =
		    (*bdevsw[major(dev)].d_open)(dev, FREAD);
		if (error) {
			/* return (error); */
			return (EIO);
		}
		/*
		 * read in superblock
		 */
		dev_vp = getmp(dev)->m_devvp;
		tp = bread(dev_vp, SBLOCK, SBSIZE);
		if (tp->b_flags & B_ERROR)
			goto out;
		fsp = tp->b_un.b_fs;
	} else
		fsp = ((struct mount *)(vp->v_vfsp->vfs_data))->m_bufp->b_un.b_fs;
	if (fsp->fs_magic != FS_MAGIC) {
		error = EINVAL;
		goto out;
	}
	sp->f_bsize = fsp->fs_bsize;
	sp->f_blocks = fsp->fs_size * (fsp->fs_fsize / 512);
			/* Block size needs to be a multiple of 512 */
	sp->f_bfree = (fsp->fs_cstotal.cs_nbfree * fsp->fs_frag +
		fsp->fs_cstotal.cs_nffree) * (fsp->fs_fsize / 512);
			/* Fragment size needs to be a multiple of 512 */
	sp->f_fstyp = MOUNT_UFS;
	sp->f_frsize = fsp->fs_fsize;
	/*
	 * inodes
	 */
	sp->f_files =  fsp->fs_ncg * fsp->fs_ipg;
	sp->f_ffree = fsp->fs_cstotal.cs_nifree;
	sp->f_fname[0] = sp->f_fpack[0] = '\0';
out:
	if(error == 0) error = u.u_error;
	if (ufstyp) {
		(*bdevsw[major(dev)].d_close)(dev, 0);
		brelse(tp);
		VN_RELE(dev_vp);
	}
	return(error);
}
#endif	SYSV
