#ifndef lint
static char sccsid[] = "@(#)authunix_prot.c 1.1 86/09/24 Copyr 1984 Sun Micro";
#endif

/*
 * authunix_prot.c
 * XDR for UNIX style authentication parameters for RPC
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */

#ifdef KERNEL
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../h/proc.h"
#endif

#include <rpc/types.h>
#include <rpc/xdr.h>
#include <rpc/auth.h>
#include <rpc/auth_unix.h>

/*
 * XDR for unix authentication parameters.
 */
bool_t
xdr_authunix_parms(xdrs, p)
	register XDR *xdrs;
	register struct authunix_parms *p;
{

	if (xdr_u_long(xdrs, &(p->aup_time))
	    && xdr_string(xdrs, &(p->aup_machname), MAX_MACHINE_NAME)
	    && xdr_int(xdrs, &(p->aup_uid))
	    && xdr_int(xdrs, &(p->aup_gid))
	    && xdr_array(xdrs, (caddr_t *)&(p->aup_gids),
		    &(p->aup_len), NGRPS, sizeof(int), xdr_int) ) {
		return (TRUE);
	}
	return (FALSE);
}

#ifdef KERNEL
/*
 * XDR kernel unix auth parameters.
 * Goes out of the u struct directly.
 * NOTE: this is an XDR_ENCODE only routine.
 */
xdr_authkern(xdrs)
	register XDR *xdrs;
{
#ifdef	is68k
	gid_t	*gp;
	int	uid = (short)u.u_uid;		/* ISI: force sign extention */
	int	gid = (short)u.u_gid;
	int	groups[NGROUPS], *lp;
#else	is68k
	int	*gp;
	int	uid = u.u_uid;
	int	gid = u.u_gid;
	caddr_t	groups;
#endif	is68k
	int	 len;
	char	*name = hostname;

	if (xdrs->x_op != XDR_ENCODE) {
		return (FALSE);
	}

	for (gp = &u.u_groups[NGRPS]; gp > u.u_groups; gp--) {
#ifdef	is68k
		if (gp[-1] != NOGROUP) {
#else	is68k
		if (gp[-1] >= 0) {
#endif	is68k
			break;
		}
	}
	len = gp - u.u_groups;
#ifdef	is68k
	for (lp = groups, gp = u.u_groups; gp < &u.u_groups[len]; )
		*lp++ = (short)(*gp++);		/* ISI: force sign extention */
#else	is68k
	groups = (caddr_t)u.u_groups;
#endif	is68k
        if (xdr_u_long(xdrs, (u_long *)&time.tv_sec)
            && xdr_string(xdrs, &name, MAX_MACHINE_NAME)
            && xdr_int(xdrs, &uid)
            && xdr_int(xdrs, &gid)
#ifdef	is68k
	    && xdr_array(xdrs, (caddr_t)groups, (u_int *)&len, NGRPS, 
		sizeof (int), xdr_int) ) {
#else	is68k
	    && xdr_array(xdrs, &groups, (u_int *)&len, NGRPS, sizeof (int), xdr_int) ) {
#endif	is68k
                return (TRUE);
	}
	return (FALSE);
}
#endif
