/*
 *  VAX/4.3BSD AppleTalk Kernel Definitions
 *  (c) 1985, 1986 Kinetics, Inc.
 */

/* ddp protocol statistics counters - should be in netstat */
struct	ddpstat {
	int	ddps_hdrops;	/* length too short */
	int	ddps_badlen;	/* wrong length, too long */
	int	ddps_ddpintr;	/* calls to ddpintr */
	int	ddps_ddppckts;	/* times thru ddpintr loop */
	int	ddps_nullifp;	/* no interface! */
	int	ddps_rtmppckts;	/* rtmp packets rcvd */
	int	ddps_shortddps;	/* short ddp pckts rcvd */
	int	ddps_wrongnet;	/* rcvd pckt not for this net */
	int	ddps_forward;	/* pckts forwarded */
	int	ddps_noddpcb;	/* undeliverable: no ddpcb */
	int	ddps_sockerr;	/* socket wouldn't accept packet */
	int	ddps_bad;	/* bad exits from ddpintr */
};

/* appletalk address */
struct a_addr {
	union {
		struct {
			u_short	Net;
			u_char	Node;
			u_char	Abridge;
		} at_chrs;
		long	Addr;
	} at_un;
};
#define at_Net		at_un.at_chrs.Net
#define	at_Node		at_un.at_chrs.Node
#define	at_Abridge	at_un.at_chrs.Abridge
#define	at_adr		at_un.Addr
struct	a_addr		*ddp_getaddr();

/* appletalk address, socket format */
#define sockaddr_at	sad_at
struct sockaddr_at {
	short		at_family;		/* AF_APPLETALK */
	struct a_addr	at_addr;		/* 4 bytes */
	u_char		at_sno;			/* ddp socket number */
	u_char		at_ptype;		/* ddp protocol type */
	char		at_dummy[8];		/* pad to 14 addr bytes */
};
#define	at_net		at_addr.at_Net
#define at_node		at_addr.at_Node
#define at_abridge	at_addr.at_Abridge

#ifdef KERNEL
struct	ddpstat		ddpstat;
#define	DDPSTAT(x)	ddpstat.ddps_/**/x++

/*
 * Structure atcb for Appletalk protocol implementation. Here are stored 
 * pointers to local and foreign addresses, local and foreign socket numbers, 
 * and pointers up (to a socket structure) and down (to a protocol-specific)
 * control block.
 */
struct atcb {
	struct	atcb		*at_next;	/* pointers to other pcb's */
	struct	atcb		*at_prev;	/* pointers to other pcb's */
	struct	sockaddr_at	at_faddr;	/* foreign address */
	struct	sockaddr_at	at_laddr;	/* local address */
	short			atcb_flags;
#define				  AT_FADDR 	1
#define				  AT_IGNADDR	2
	short			atcb_ptype;	/* protocol type */
	struct	socket		*at_socket;	/* back pointer to socket */
	caddr_t			at_ppcb;	/* pointer to protocol pcb */
};
#define	at_fport	at_faddr.at_sno
#define	at_fnet		at_faddr.at_net
#define	at_fnode	at_faddr.at_node
#define	at_lport	at_laddr.at_sno
#define	at_lnet		at_laddr.at_net
#define	at_lnode	at_laddr.at_node
#define	sotoatcb(so)	((struct atcb *)(so)->so_pcb)
#define ATPORT_RESERVED	128
struct	atcb		*at_pcblookup();

struct	atif {		/* Interface/AppleTalk address pairs */
	struct ifnet *ifp;	/* if pointer */
	struct a_addr aa;	/* AppleTalk info per if */
};
extern	struct atif		atiflist[];
#define	ddp_setifp(i,n)		{atiflist[(int)(n)].ifp = (i); 		\
				atiflist[(int)(n)].aa.at_Node = (n);}
#define	ddp_deleteifp(n)	{atiflist[(int)(n)].ifp = 0;		\
				atiflist[(int)(n)].aa.at_Node = 0;}

/* misc */
struct	ifqueue			ddpintq;	/* ddp packet input queue */
#define	ATPLOOKUP_WILDCARD	1
extern	ddpintr();
struct ifnet *atroute();
#endif	KERNEL
